% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Assumptions_resample.R
\name{Assumptions_resample}
\alias{Assumptions_resample}
\title{Compute power for Multiple Regression with Violated assumptions using Resamples}
\usage{
Assumptions_resample(
  ry1 = NULL,
  ry2 = NULL,
  ry3 = NULL,
  ry4 = NULL,
  ry5 = NULL,
  r12 = NULL,
  r13 = NULL,
  r14 = NULL,
  r15 = NULL,
  r23 = NULL,
  r24 = NULL,
  r25 = NULL,
  r34 = NULL,
  r35 = NULL,
  r45 = NULL,
  sy = NULL,
  s1 = NULL,
  s2 = NULL,
  s3 = NULL,
  s4 = NULL,
  s5 = NULL,
  ky = NULL,
  k1 = NULL,
  k2 = NULL,
  k3 = NULL,
  k4 = NULL,
  k5 = NULL,
  n = NULL,
  alpha = 0.05,
  test = "boot",
  reps = 200,
  boots = 500
)
}
\arguments{
\item{ry1}{Correlation between DV (y) and first predictor (1)}

\item{ry2}{Correlation between DV (y) and second predictor (2)}

\item{ry3}{Correlation between DV (y) and third predictor (3)}

\item{ry4}{Correlation between DV (y) and fourth predictor (4)}

\item{ry5}{Correlation between DV (y) and fifth predictor (5)}

\item{r12}{Correlation between first (1) and second predictor (2)}

\item{r13}{Correlation between first (1) and third predictor (3)}

\item{r14}{Correlation between first (1) and fourth predictor (4)}

\item{r15}{Correlation between first (1) and fifth predictor (5)}

\item{r23}{Correlation between second (2) and third predictor (3)}

\item{r24}{Correlation between second (2) and fourth predictor (4)}

\item{r25}{Correlation between second (2) and fifth predictor (5)}

\item{r34}{Correlation between third (3) and fourth predictor (4)}

\item{r35}{Correlation between third (3) and fifth predictor (5)}

\item{r45}{Correlation between fourth (4) and fifth predictor (5)}

\item{sy}{Skew of outcome variable}

\item{s1}{Skew of first predictor}

\item{s2}{Skew of second predictor}

\item{s3}{Skew of third predictor}

\item{s4}{Skew of fourth predictor}

\item{s5}{Skew of fifth predictor}

\item{ky}{Kurtosis of outcome variable}

\item{k1}{Kurtosis of first predictor}

\item{k2}{Kurtosis of second predictor}

\item{k3}{Kurtosis of third predictor}

\item{k4}{Kurtosis of fourth predictor}

\item{k5}{Kurtosis of fifth predictor}

\item{n}{Sample size}

\item{alpha}{Type I error (default is .05)}

\item{test}{type of test ("boot","jack","perm")}

\item{reps}{number of replications, default is 200 - use larger for final analyses}

\item{boots}{number of bootstrap samples. Default is 500. Use larger for final.}
}
\value{
Power for Multiple Regression with Non Normal Variables via resample
}
\description{
Compute power for Multiple Regression with Violated assumptions using Resamples
}
\examples{
\donttest{Assumptions_resample(ry1=.0,ry2=.3,r12=.3,sy=1,s1=2,s2=2,ky=1,k1=1,k2=1,n=100)}
}
