% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medjs.R
\name{medjs}
\alias{medjs}
\title{Compute Power for Mediated (Indirect) Effects Using Joint Significance
Requires correlations between all variables as sample size.
This is the recommended approach for determining power}
\usage{
medjs(
  rx1x2 = NULL,
  rx1m1,
  rx1m2 = NULL,
  rx1m3 = NULL,
  rx1m4 = NULL,
  rx1y,
  rx2m1 = NULL,
  rx2m2 = NULL,
  rx2m3 = NULL,
  rx2m4 = NULL,
  rx2y,
  rym1,
  rym2 = NULL,
  rym3 = NULL,
  rym4 = NULL,
  rm1m2 = NULL,
  rm1m3 = NULL,
  rm1m4 = NULL,
  rm2m3 = NULL,
  rm2m4 = NULL,
  rm3m4 = NULL,
  n,
  alpha = 0.05,
  mvars,
  pred = 1,
  reps = 1000
)
}
\arguments{
\item{rx1x2}{Correlation between first predictor (x1) and second predictor (x2)}

\item{rx1m1}{Correlation between first predictor (x1) and first mediator (m1)}

\item{rx1m2}{Correlation between first predictor (x1) and second mediator (m2)}

\item{rx1m3}{Correlation between first predictor (x1) and third mediator (m3)}

\item{rx1m4}{Correlation between first predictor (x1) and fourth mediator (m4)}

\item{rx1y}{Correlation between DV (y) and first predictor (x1)}

\item{rx2m1}{Correlation between second predictor (x2) and first mediator (m1)}

\item{rx2m2}{Correlation between second predictor (x2) and second mediator (m2)}

\item{rx2m3}{Correlation between second predictor (x2) and third mediator (m3)}

\item{rx2m4}{Correlation between second predictor (x2) and fourth mediator (m4)}

\item{rx2y}{Correlation between DV (y) and second predictor (x2)}

\item{rym1}{Correlation between DV (y) and first mediator (m1)}

\item{rym2}{Correlation between DV (y) and second mediator (m2)}

\item{rym3}{Correlation DV (y) and third mediator (m3)}

\item{rym4}{Correlation DV (y) and fourth mediator (m4)}

\item{rm1m2}{Correlation first mediator (m1) and second mediator (m2)}

\item{rm1m3}{Correlation first mediator (m1) and third mediator (m3)}

\item{rm1m4}{Correlation first mediator (m1) and fourth mediator (m4)}

\item{rm2m3}{Correlation second mediator (m2) and third mediator (m3)}

\item{rm2m4}{Correlation second mediator (m2) and fourth mediator (m4)}

\item{rm3m4}{Correlation third mediator (m3) and fourth mediator (m4)}

\item{n}{Sample size}

\item{alpha}{Type I error (default is .05)}

\item{mvars}{Number of Mediators}

\item{pred}{Number of Predictors}

\item{reps}{Number of samples (default is 1000)}
}
\value{
Power for Mediated (Indirect) Effects
}
\description{
Compute Power for Mediated (Indirect) Effects Using Joint Significance
Requires correlations between all variables as sample size.
This is the recommended approach for determining power
}
\examples{
\donttest{medjs(rx1m1=.25, rx1y=-.35, rym1=-.5,mvars=1, n=150)}
\donttest{medjs(rx1m1=.3, rx1m2=.3, rx1m3=.25, rx1y=-.35, rym1=-.5,rym2=-.5,
rym3 = -.5,rm1m2=.7, rm1m3=.4,rm2m3=.4, mvars=3, n=150)}
}
