% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{flatten}
\alias{flatten}
\alias{flatten_lgl}
\alias{flatten_int}
\alias{flatten_dbl}
\alias{flatten_chr}
\alias{flatten_df}
\title{Flatten a list of lists into a simple vector.}
\usage{
flatten(.x)

flatten_lgl(.x)

flatten_int(.x)

flatten_dbl(.x)

flatten_chr(.x)

flatten_df(.x, .id = NULL)
}
\arguments{
\item{.x}{A list of flatten. The contents of the list can be anything for
\code{flatten} (as a list is returned), but the contents must match the
type for the other functions.}

\item{.id}{If not \code{NULL} a variable with this name will be created
giving either the name or the index of the data frame.}
}
\value{
\code{flatten()} returns a list, \code{flatten_lgl} a logical
  vector, \code{flatten_int} an integer vector, \code{flatten_dbl} a
  double vector, and \code{flatten_chr} a character vector.
}
\description{
These functions remove a level hierarchy from a list. They are similar to
\code{\link{unlist}}, only ever remove a single layer of hierarchy, and
are type-stable so you always know what the type of the output is.
}
\examples{
x <- rerun(2, sample(4))
x
x \%>\% flatten()
x \%>\% flatten_int()

# You can use flatten in conjunction with map
x \%>\% map(1L) \%>\% flatten_int()
# But it's more efficient to use the typed map instead.
x \%>\% map_int(1L)
}
