% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/every-some.R
\name{every}
\alias{every}
\alias{some}
\title{Do every or some elements of a list satisfy a predicate?}
\usage{
every(.x, .p, ...)

some(.x, .p, ...)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.p}{A single predicate function, a formula describing such a
predicate function, or a logical vector of the same length as \code{.x}.
Alternatively, if the elements of \code{.x} are themselves lists of
objects, a string indicating the name of a logical element in the
inner lists. Only those elements where \code{.p} evaluates to
\code{TRUE} will be modified.}

\item{...}{Additional arguments passed on to \code{.f}.}
}
\value{
Either \code{TRUE} or \code{FALSE}.
}
\description{
Do every or some elements of a list satisfy a predicate?
}
\examples{
x <- list(0, 1, TRUE)
x \%>\% every(identity)
x \%>\% some(identity)

y <- list(0:10, 5.5)
y \%>\% every(is.numeric)
y \%>\% every(is.integer)
}
