% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{ped_clean}
\alias{ped_clean}
\title{Remove individuals not used for purging analyses}
\usage{
ped_clean(ped, value_from)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{value_from}{Name of the column of interest.}
}
\value{
A dataframe with the pedigree cleaned for the specificed parameter (column) provided.
}
\description{
Remove individuals that are not necessary for purging analyses involving fitness.
This will reduce the size of the pedigree, and speed up the computation of inbreeding
parameters.
Individuals removed include those with unknown (NA)
values of a given parameter and that do not have any descendant in the
pedigree with known values of that parameter.
Cleaned pedigrees will automatically have individual identities
renamed (see \code{\link[purgeR]{ped_rename}}).
}
\examples{
data(arrui)
nrow(arrui)
arrui <- ped_clean(arrui, "survival15")
nrow(arrui)
}
\seealso{
\code{\link[purgeR]{ped_rename}}
}
