% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{cosm_reg}
\alias{cosm_reg}
\title{Cosmetics for tables of regression coefficients.
Converts tables generated by \code{\link[gtsummary]{tbl_regression}} to \code{\link[huxtable]{huxtable}} and adds some cosmetics.}
\usage{
cosm_reg(gt_tbl, pad = 3, type = 3, bold = TRUE, head_label = "**Variable**")
}
\arguments{
\item{gt_tbl}{A table object generated by \code{\link[gtsummary]{tbl_regression}}.}

\item{pad}{Numerical, padding above and bellow rows.}

\item{type}{Anova's type to calculate global p-values.}

\item{bold}{Display labels in bold?}

\item{head_label}{Character, label to be used as head for the variable's column.}
}
\value{
A \code{\link[huxtable]{huxtable}}.
}
\description{
Cosmetics for tables of regression coefficients.
Converts tables generated by \code{\link[gtsummary]{tbl_regression}} to \code{\link[huxtable]{huxtable}} and adds some cosmetics.
}
\examples{
require(sjlabelled, quietly = TRUE)

data(diet, package = "Epi")
diet <- diet \%>\%
  var_labels(
    chd = "Coronary Heart Disease",
    fibre = "Fibre intake (g/day)"
  )

model_binom <- glm(chd ~ fibre, data = diet, family = binomial)

model_binom \%>\%
  tbl_regression(exponentiate = TRUE) \%>\%
  cosm_reg(bold = TRUE) \%>\%
  theme_pubh(1) \%>\%
  add_footnote(get_r2(model_binom), font_size = 9)

data(birthwt, package = "MASS")
birthwt <- birthwt \%>\%
  mutate(
    smoke = factor(smoke, labels = c("Non-smoker", "Smoker")),
    race = factor(race, labels = c("White", "African American", "Other"))
  ) \%>\%
  var_labels(
    bwt = "Birth weight (g)",
    smoke = "Smoking status",
    race = "Race"
  )

model_norm <- lm(bwt ~ smoke + race, data = birthwt)

model_norm \%>\%
  tbl_regression() \%>\%
  cosm_reg(bold = TRUE) \%>\%
  theme_pubh(1) \%>\%
  add_footnote(get_r2(model_norm), font_size = 9)
}
