% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{freq_cont}
\alias{freq_cont}
\title{Relative and Cumulative Frequency.}
\usage{
freq_cont(x, bks, dg = 2)
}
\arguments{
\item{x}{A numerical (continuous) variable. Ideally, relatively long (greater than 100 observations).}

\item{bks}{Breaks defining the classes (see example).}

\item{dg}{Number of digits for rounding (default = 2).}
}
\value{
A data frame with the classes, the mid-point, the frequencies, the relative and cumulative frequencies.
}
\description{
\code{freq_cont} tabulates a continuous variable by given classes.
}
\examples{
data(IgM, package="ISwR")
Ab <- data.frame(IgM)
estat(~ IgM, data = Ab)
freq_cont(IgM, seq(0, 4.5, 0.5))
}
