% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/departures.R
\name{departures}
\alias{departures}
\title{Departures from a given stop}
\usage{
departures(
  stop_id,
  route_type,
  route_id = NULL,
  direction_id = NULL,
  platform_numbers = NULL,
  departs = Sys.time(),
  look_backwards = FALSE,
  max_results = 5,
  include_cancelled = FALSE,
  validate_results = TRUE,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{stop_id}{An integer stop ID returned by the \code{stops_on_route} or
\code{stops_nearby} functions.}

\item{route_type}{A route type which can be provided either as a non-negative
integer code, or as a character: "Tram", "Train", "Bus", "Vline" or "Night
Bus". Character inputs are not case-sensitive. Use the
\code{\link{route_types}} function to extract a vector of all route types.}

\item{route_id}{Optionally filter by a route ID. These can be obtained with
the \code{routes} function.}

\item{direction_id}{Optionally filter by a direction ID. These can be
obtained with the \code{\link{directions_on_route}} function.}

\item{platform_numbers}{Character vector. Optionally filter results by
platform number. Despite the name, these are characters.}

\item{departs}{POSIXct or Character. Optionally filter results to departures
on or after the given value, according to either scheduled or estimated
departure time. Characters are automatically converted to datetimes, and
are assumed to be given as Melbourne time. Defaults to the current system
time.}

\item{look_backwards}{Boolean. Whether to look before \code{departs}. Use with
caution (see Details). Defaults to \code{FALSE}.}

\item{max_results}{Integer. The maximum number of departures to return for
each route_id. Departures are ordered by estimated departure time, when
available, and scheduled departure time otherwise. When set to 0, all
departures after the given \code{departs} for the entire day are shown, and
potentially some in the early hours of the next morning. Defaults to 5.}

\item{include_cancelled}{Logical. Whether results should be returned if they
have been cancelled. Metropolitan train services only. Defaults to FALSE.}

\item{validate_results}{Boolean. If TRUE (the default), will apply additional
filters to ensure that the arguments to \code{departs}, \code{max_results}, and
\code{route_id} are respected if given.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble consisting of the following columns: \itemize{
\item \code{stop_id}
\item \code{route_id}
\item \code{run_id} (deprecated, use \code{run_ref} instead)
\item \code{run_ref}
\item \code{direction_id}
\item \code{disruption_ids}
\item \code{scheduled_departure}
\item \code{estimated_departure}
\item \code{at_platform}
\item \code{platform_number}
\item \code{flags}
\item \code{departure_sequence}
}
}
\description{
\code{departures} retrieves all upcoming departures for a given stop ID and route
type.
}
\details{
Filtering departures: The API supports filtering by departure time,
to show the departures after the given time. However, its behaviour is
unpredictable, returning departures around the given time, both before and
after. We apply an additional filter once the results are retrieved to
ensure that only departures at or after the given \code{departs} datetime are
shown.

It's not clear what functionality \code{look_backwards} has. It's included here
regardless. Moreover, it's not clear how the API treats \code{route_id} or
\code{max_results}. We filter the results after retrieval, to ensure that
\code{departs}, \code{max_results}, and \code{route_id} are respected. This additional
validation can be disabled by setting \code{validate_results = TRUE}.
}
\examples{
\dontrun{
departures(stop_id = 1071, route_type = "Train")
departures(stop_id = 1071, route_type = 0)

departures(
  stop_id = 1071,
  route_type = "Train",
  platform_numbers = c(4, 5)
)

departures(
  stop_id = 1071,
  route_type = "Train",
  route_id = 6
)

departures(
  stop_id = 1071,
  route_type = "Train",
  departs = "2020-06-23 17:05:00"
)

}

}
