% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directions.R
\name{directions}
\alias{directions}
\title{Directions for a given direction ID}
\usage{
directions(
  direction_id,
  route_type = NULL,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{direction_id}{Integer.}

\item{route_type}{Optionally filter results by a route type. A route type can
be provided either as a non-negative integer code, or as a character:
"Tram", "Train", "Bus", "Vline" or "Night Bus". Character inputs are not
case-sensitive. Use the \code{route_types} function to extract a vector of all
route types.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble consisting of the following columns: \itemize{
\item \code{direction_id}
\item \code{direction_name},
\item \code{route_id}
\item \code{route_type}
\item \code{route_direction_description}
}
}
\description{
This function returns all directions with a given ID. Directions that share
an ID are not necessarily related, especially if not filtering by route type.
It's advised to use to the \code{directions_on_route} function to search for
directions of interest.
}
\examples{
\dontrun{
directions(direction_id = 5)
directions(direction_id = 5, route_type = "Train")
directions(direction_id = 5, route_type = 0)
}

}
