% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_graph.R
\name{get_graph.lavaan}
\alias{get_graph.lavaan}
\title{Get graph data from lavaan or blavaan objects.}
\usage{
\method{get_graph}{lavaan}(fit, links = c("Regression", "Correlation",
  "Loading"), standardize = FALSE, threshold_Coef = NULL,
  threshold_p = NULL, threshold_MPE = NULL, digits = 2,
  CI = "default", labels_CI = TRUE, ...)
}
\arguments{
\item{fit}{lavaan object.}

\item{links}{Which links to include? A list including at least one of "Regression", "Loading" or "Correlation".}

\item{standardize}{Use standardized coefs.}

\item{threshold_Coef}{Omit all links with a Coefs below this value.}

\item{threshold_p}{Omit all links with a p value above this value.}

\item{threshold_MPE}{In case of a blavaan model, omit all links with a MPE value below this value.}

\item{digits}{Edges' labels rounding.}

\item{CI}{CI level.}

\item{labels_CI}{Add the CI in the edge label.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A list containing nodes and edges data to be used by `tidygraph::tbl_graph()`.
}
\description{
Get graph data from lavaan or blavaan objects.
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
