% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{pspline.validate.scalars}
\alias{pspline.validate.scalars}
\title{Run a simulation study to validate a scalar estimator}
\usage{
pspline.validate.scalars(
  fun.truth,
  n.truths,
  fun.observations,
  n.observations,
  fun.model,
  fun.outcomes,
  n.samples,
  level
)
}
\arguments{
\item{fun.truth}{function that generates a true state of the system. Takes no arguments, returns data frame of true values for model variables}

\item{n.truths}{number of different truths to generate for simulation study}

\item{fun.observations}{function that generates a set of observations from truth. Takes one argument (truth data frame) and returns data frame of observations}

\item{n.observations}{number of sets of observations to generate for each truth in the simulation study}

\item{fun.model}{function that returns a model to be used for estimation. Takes one argument (observations data frame) and returns the model}

\item{fun.outcomes}{function that calculates the outcomes of interest. Same as outcomes function in \code{\link{pspline.estimate.scalars}}.}

\item{n.samples}{number of samples to use for estimation. See \code{\link{pspline.estimate.scalars}}.}

\item{level}{confidence level to use for estimation. See \code{\link{pspline.estimate.scalars}}.}
}
\value{
list of summary (which is a data frame specifying the fraction of true values that were contained in their estimated confidence interval) and results (which is a data frame specifying the quantile of the true value in the estimated sampled distribution for each simulation)
}
\description{
Run a simulation study to validate a scalar estimator
}
