% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sptime.R
\name{plot_sptime}
\alias{plot_sptime}
\title{Plot of time trends for spatio-temporal models in 3d.}
\usage{
plot_sptime(object, data, time_var, reg_var)
}
\arguments{
\item{object}{object returned from \code{\link{pspatfit}}}

\item{data}{either sf or dataframe with the data.}

\item{time_var}{name of the temporal variable in data.}

\item{reg_var}{name of the regional variable in data.}
}
\value{
time series plots of the temporal trend for each region
}
\description{
Make plots of the temporal trends for each region
   fitted with \code{\link{pspatfit}} function.
}
\examples{
library(pspatreg)
data(unemp_it, package = "pspatreg")
lwsp_it <- spdep::mat2listw(Wsp_it)

###### FORMULA OF THE MODEL
form3d_psanova <- unrate ~ partrate + agri + cons +
                  pspl(serv, nknots = 15) + 
                  pspl(empgrowth, nknots = 20) +
                  pspt(long, lat, year, 
                       nknots = c(18, 18, 8),
                       psanova = TRUE, 
                       nest_sp1 = c(1, 2, 3), 
                       nest_sp2 = c(1, 2, 3),
                       nest_time = c(1, 2, 2))

\donttest{
####### FIT the model
sp3danova <- pspatfit(form3d_psanova, 
                      data = unemp_it, 
                      listw = lwsp_it, 
                      method = "Chebyshev") 

summary(sp3danova)

######## Plot of temporal trend for each province 
plot_sptime(sp3danova, 
            data = unemp_it, 
            time_var = "year", 
            reg_var = "prov")
}

}
\references{
\itemize{ 
  \item Lee, D. and Durban, M. (2011). P-Spline ANOVA Type Interaction 
    Models for Spatio-Temporal Smoothing. \emph{Statistical Modelling}, 
    (11), 49-69. <doi:10.1177/1471082X1001100104>
    
  \item Eilers, P. and Marx, B. (2021). \emph{Practical Smoothing. 
  The Joys of P-Splines}. Cambridge University Press.
    
  \item Fahrmeir, L.; Kneib, T.;  Lang, S.; and Marx, B. (2013). 
    \emph{Regression. Models, Methods and Applications}.
     Springer.
        
  \item Wood, S.N. (2017). \emph{Generalized Additive Models. 
  An Introduction with \code{R}} (second edition). CRC Press, Boca Raton.
 }
}
\author{
\tabular{ll}{ 
  Roman Minguez  \tab \email{roman.minguez@uclm.es} \cr
  Roberto Basile \tab \email{roberto.basile@univaq.it} \cr Maria Durban \tab
  \email{mdurban@est-econ.uc3m.es} \cr Gonzalo Espana-Heredia \tab
  \email{gehllanza@gmail.com} \cr 
 }
}
