% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/composite.R
\name{distanceScores}
\alias{distanceScores}
\title{Calculate distance scores on data in preparation for composite scoring}
\usage{
distanceScores(d, g, thresholds, higherisbetter, winsorize = FALSE,
  better = TRUE, na.rm = TRUE, saveall = FALSE)
}
\arguments{
\item{d}{The data}

\item{g}{A grouping variable}

\item{thresholds}{Thresholds to use when calculating distances
(e.g., median, clinical thresholds, etc.).  If groups are used,
must be thresholds for each group (e.g., to allow separate thresholds for
females and males).}

\item{higherisbetter}{A logical vector for each biomarker whether higher scores
are better or not.}

\item{winsorize}{Whether to winsorize the data or not.  Defaults to \code{FALSE}.
If not \code{FALSE}, the percentile to winsorize at.  For example, .01 would be
the .01 and the 1 - .01 percentiles.}

\item{better}{Logical indicating whether \dQuote{better} values than the threshold
are allowed. Defaults to \code{TRUE}.}

\item{na.rm}{A logical whether missing values should be ommitted. Defaults to
\code{TRUE}.}

\item{saveall}{A logical whether to save all intermediary datasets and graphs.
Defaults to \code{FALSE}.}
}
\value{
A list of results.
}
\description{
Calculate distance scores on data in preparation for composite scoring
}
\examples{
# this example creates distances for the built in mtcars data
# see ?mtcars for more details
# The distances are calculated from the "best" in the dataset
# defined by these thresholds
thresholds <- with(mtcars, c(
  mpg = max(mpg),
  hp = max(hp),
  wt = min(wt),
  qsec = min(qsec)))

# higher mpg and hp are better,
# whereas lower wt and qsec are better
dres <- distanceScores(mtcars[, c("mpg", "hp", "wt", "qsec")],
  thresholds = list(thresholds),
  higherisbetter = c(TRUE, TRUE, FALSE, FALSE),
  saveall = TRUE)

# see a density plot of the distance scores
dres$Density

# cleanup
rm(thresholds, dres)
}
\seealso{
Other composite: \code{\link{factorComposite}};
  \code{\link{mahalanobisComposite}};
  \code{\link{prepareComposite}};
  \code{\link{sumComposite}}
}

