% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu_cov.R
\name{simu_cov}
\alias{simu_cov}
\alias{simu_cov,matrix-method}
\title{Simulate covariates}
\usage{
simu_cov(ssObj, covObj, driftHR, HR, nsim, seed, path)
}
\arguments{
\item{ssObj}{an object of class \code{.covClass} generated in \code{\link{set_n}}}

\item{covObj}{an object of class \code{.covClass} generated in \code{\link{set_cov}}}

\item{driftHR}{hazard ratio of external control and internal control arms}

\item{HR}{a list of hazard ratio of treatment and control arms}

\item{nsim}{number of simulation. Default is 5}

\item{seed}{the seed of R‘s random number generator. Default is the first element of .Random.seed}

\item{path}{file name for saving the output including folder path}
}
\value{
a list of \code{matrix} containing simulated covariates information
}
\description{
This function generates continuous and binary covariates through simulating from a multivariate normal distribution. Outcomes are further converted to binary variables using quantiles of the normal distribution calculated from the probability provided. Then the covariates are added to the external trial and treatment arm indicators.
}
\examples{
# simulate patient-level data with 1 continuous covariate
sample = set_n(ssC = 10, ssE = 20, ssExt = 40)
cov1 = set_cov(n_cat = 0, n_cont = 1, mu_int = 0, mu_ext = 0, var = 1)
simu_cov(ssObj = sample, covObj = cov1, HR = 0.5, driftHR = 1, nsim = 2)

# simulate patient-level data with 1 binary and 2 continuous covariate
cov2 = set_cov(n_cat = 1, n_cont = 2, mu_int = 0, mu_ext = 0, var = 1,
               cov = 0.3, prob_int = 0.2, prob_ext = 0.3)
simu_cov(ssObj = sample, covObj = cov2, HR = 0.5, driftHR = 1, nsim = 2)


}
\keyword{simulator}
