% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_create_time}
\alias{ps_create_time}
\title{Start time of a process}
\usage{
ps_create_time(p)
}
\arguments{
\item{p}{Process handle.}
}
\value{
\code{POSIXct} object, start time, in GMT.
}
\description{
The pid and the start time pair serves as the identifier of the process,
as process ids might be reused, but the chance of starting two processes
with identical ids within the resolution of the timer is minimal.
}
\details{
This function works even if the process has already finished.
}
\seealso{
Other process handle functions: \code{\link{ps_children}},
  \code{\link{ps_cmdline}}, \code{\link{ps_connections}},
  \code{\link{ps_cpu_times}}, \code{\link{ps_cwd}},
  \code{\link{ps_environ}}, \code{\link{ps_exe}},
  \code{\link{ps_handle}}, \code{\link{ps_interrupt}},
  \code{\link{ps_is_running}}, \code{\link{ps_kill}},
  \code{\link{ps_memory_info}}, \code{\link{ps_name}},
  \code{\link{ps_num_fds}}, \code{\link{ps_num_threads}},
  \code{\link{ps_open_files}}, \code{\link{ps_pid}},
  \code{\link{ps_ppid}}, \code{\link{ps_resume}},
  \code{\link{ps_send_signal}}, \code{\link{ps_status}},
  \code{\link{ps_suspend}}, \code{\link{ps_terminal}},
  \code{\link{ps_terminate}}, \code{\link{ps_uids}},
  \code{\link{ps_username}}
}
\concept{process handle functions}
\section{Examples}{
\Sexpr[stage=install,strip.white=FALSE,results=rd]{ps:::decorate_examples('
p <- ps_handle()
p
ps_create_time(p)
')}
}
