/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.http;

import com.qarks.util.http.HttpHeader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class HttpResponse {
    public static final String HTTP_OK = "HTTP/1.0 200 OK";
    public static final String HTTP_NOT_FOUND = "HTTP/1.0 404";
    public static final String HTTP_INTERNAL_SERVER_ERROR = "HTTP/1.0 500";
    public static final String HTTP_FORBIDDEN = "HTTP/1.0 403";
    public static final String HTTP_MOVED = "HTTP/1.0 301";
    public static final String HTTP_FOUND = "HTTP/1.0 302";
    private OutputStream responseOutputStream;
    protected String responseCode;
    protected HttpHeader headers = new HttpHeader();
    protected byte[] data;
    protected boolean firstPacketSent = false;
    protected ZipOutputStream zipOut = null;

    public HttpResponse(OutputStream outputStream) {
        this.responseOutputStream = outputStream;
        this.headers.setHeaderValue("cache-control", "private");
    }

    protected void close() {
        try {
            this.responseOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public HttpHeader getHeaders() {
        return this.headers;
    }

    public void setContentType(String string) {
        this.headers.setHeaderValue("content-type", string);
    }

    public void setContentLength(long l) {
        this.headers.setHeaderValue("content-length", Long.toString(l));
    }

    public void sendFullResponse(String string, String string2) throws Exception {
        byte[] byArray = string.getBytes("UTF-8");
        this.sendFullResponse(byArray, byArray.length, "UTF-8", string2);
    }

    public void sendFullResponse(String string) throws Exception {
        byte[] byArray = string.getBytes("UTF-8");
        this.sendFullResponse(byArray, byArray.length, "UTF-8", "text/plain");
    }

    public void sendFullResponse(byte[] byArray, int n, String string, String string2) throws IOException {
        this.responseCode = HTTP_OK;
        this.headers.setHeaderValue("transfer-encoding", string);
        this.setContentType(string2);
        this.setContentLength(n);
        this.doSendHeader();
        this.writeData(byArray, 0, n);
    }

    public void sendResponsePacket(long l, byte[] byArray, int n, boolean bl) throws IOException {
        if (!this.firstPacketSent) {
            this.setContentLength(l);
            this.responseCode = HTTP_OK;
            this.doSendHeader();
            this.firstPacketSent = true;
        }
        this.writeData(byArray, 0, n);
        if (bl) {
            // empty if block
        }
    }

    private void writeData(byte[] byArray, int n, int n2) throws IOException {
        if (this.shouldZipData()) {
            this.getZipOutputStream().write(byArray, n, n2);
        } else {
            this.responseOutputStream.write(byArray, n, n2);
        }
    }

    private boolean shouldZipData() {
        return "gzip".equals(this.getHeaders().getHeaderValue("transfer-encoding")) || "gzip".equals(this.getHeaders().getHeaderValue("content-encoding"));
    }

    private ZipOutputStream getZipOutputStream() throws IOException {
        if (this.zipOut == null) {
            System.err.println("using gzip");
            this.zipOut = new ZipOutputStream(this.responseOutputStream);
            this.zipOut.putNextEntry(new ZipEntry(""));
        }
        return this.zipOut;
    }

    public void sendRedirect(String string) throws Exception {
        this.getHeaders().setHeaderValue("Location", string);
        this.sendErrorCode(HTTP_FOUND);
    }

    public void sendErrorCode(String string) throws Exception {
        this.responseCode = string;
        this.doSendHeader();
    }

    protected OutputStream getOutputStream() {
        return this.responseOutputStream;
    }

    private void doSendHeader() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.responseCode);
        stringBuffer.append("\r\n");
        stringBuffer.append(this.headers.toString());
        this.responseOutputStream.write(stringBuffer.toString().getBytes("ASCII"));
    }
}

