% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debugTypeChanges.R
\name{debug.type.changes}
\alias{debug.type.changes}
\title{Tracking Type Changes}
\usage{
debug.type.changes(...)
}
\arguments{
\item{...}{Optional. Variable name(s) to be queried. If variables are given (not NULL),
the results will be filtered to show only those with the given variable name.}
}
\value{
A list of data frames for each variable with at least 1 data type change.
}
\description{
Returns a data frame for each variable in the execution containing the 
instances where the data type changed.
Each data frame contains the following columns:
\itemize{
	\item value: The value of the variable.
	\item container: The type of the container of the variable.
	\item dimension: The size of the container.
	\item type: The data type(s) contained within the container.
	\item code: The line of code associated with the variable.
	\item scriptNum: The script number associated with the variable.
	\item scriptName: The name of the script associated with the variable.
	\item startLine: The line number associated with the variable.
}
}
\details{
debug.type.changes belongs to provDebugR, a debugger which utilises provenance 
collected post-execution to facilitate understanding of the execution and aid 
in debugging.

This function may be used only after the debugger has been initialised using
one its initialisation functions (listed below).
}
\examples{
\dontrun{
prov.debug.run("test.R")
debug.type.changes()
debug.type.changes(x)
debug.type.changes("a", "b")
}

}
\seealso{
provDebugR Initialisation Functions:

\code{\link{prov.debug}}

\code{\link{prov.debug.file}}

\code{\link{prov.debug.run}}

Other provDebugR Functions (non-initialisation):

\code{\link{debug.error}}: Returns the backwards lineage of the error, if any.
             The error may be queried on StackOverflow.

\code{\link{debug.line}}: Returns all immediate inputs and outputs
             for the line(s) queried.

\code{\link{debug.lineage}}: Returns the forwards or backwards lineage
             of the data object(s) queried. The forwards lineage shows how the
             data object was used, and the backwards lineage shows how it was produced.

\code{\link{debug.state}}: Returns the state at the line(s) queried,
             after the line had been executed. The state is the list of all 
             variables and their values in the environment at the queried line.

\code{\link{debug.variable}}: Returns a data frame showing all instances
             of the variable(s) queried.

\code{\link{debug.view}}: Opens and displays the contents of each file or variable
             or variable queried.

\code{\link{debug.warning}}: Returns the backwards lineage of the queried
             warning(s), if any.
}
