% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_alphafold_prediction.R
\name{fetch_alphafold_prediction}
\alias{fetch_alphafold_prediction}
\title{Fetch AlphaFold prediction}
\usage{
fetch_alphafold_prediction(
  uniprot_ids = NULL,
  organism_name = NULL,
  version = "v4",
  timeout = 3600,
  return_data_frame = FALSE,
  show_progress = TRUE
)
}
\arguments{
\item{uniprot_ids}{optional, a character vector of UniProt identifiers for which predictions
should be fetched. This argument is mutually exclusive to the \code{organism_name} argument.}

\item{organism_name}{optional, a character value providing the name of an organism for which
all available AlphaFold predictions should be retreived. The name should be the capitalised
scientific species name (e.g. "Homo sapiens"). \strong{Note:} Some organisms contain a lot of
predictions which might take a considerable amount of time and memory to fetch. Therefore, you
should be sure that your system can handle fetching predictions for these organisms. This
argument is mutually exclusive to the \code{uniprot_ids} argument.}

\item{version}{a character value that specifies the alphafold version that should be used. This
is regularly updated by the database. We always try to make the current version the default version.
Available version can be found here: https://ftp.ebi.ac.uk/pub/databases/alphafold/}

\item{timeout}{a numeric value specifying the time in seconds until the download of an organism
archive times out. The default is 3600 seconds.}

\item{return_data_frame}{a logical value that specifies if true, a data frame instead of a list
is returned. It is recommended to only use this if information for few proteins is retrieved.
Default is FALSE.}

\item{show_progress}{a logical value that specifies if true, a progress bar will be shown.
Default is TRUE.}
}
\value{
A list that contains atom level data for AlphaFold predictions. If return_data_frame is
TRUE, a data frame with this information is returned instead. The data frame contains the
following columns:
\itemize{
\item label_id: Uniquely identifies every atom in the prediction following the standardised
convention for mmCIF files.
\item type_symbol: The code used to identify the atom species representing this atom type.
This code is the element symbol.
\item label_atom_id: Uniquely identifies every atom for the given residue following the
standardised convention for mmCIF files.
\item label_comp_id: A chemical identifier for the residue. This is the three- letter code
for the amino acid.
\item label_asym_id: Chain identifier following the standardised convention for mmCIF files.
Since every prediction only contains one protein this is always "A".
\item label_seq_id: Uniquely and sequentially identifies residues for each protein. The
numbering corresponds to the UniProt amino acid positions.
\item x: The x coordinate of the atom.
\item y: The y coordinate of the atom.
\item z: The z coordinate of the atom.
\item prediction_score: Contains the prediction score for each residue.
\item auth_seq_id: Same as \code{label_seq_id}. But of type character.
\item auth_comp_id: Same as \code{label_comp_id}.
\item auth_asym_id: Same as \code{label_asym_id}.
\item uniprot_id: The UniProt identifier of the predicted protein.
\item score_quality: Score annotations.
}
}
\description{
Fetches atom level data for AlphaFold predictions either for selected proteins or whole
organisms.
}
\examples{
\donttest{
alphafold <- fetch_alphafold_prediction(
  uniprot_ids = c("F4HVG8", "O15552"),
  return_data_frame = TRUE
)

head(alphafold, n = 10)
}
}
