% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-propr.R, R/2-proprCall.R
\docType{class}
\name{propr}
\alias{propr}
\alias{propr-class}
\alias{show,propr-method}
\alias{propr}
\alias{phit}
\alias{perb}
\alias{phis}
\alias{corr}
\alias{subset,propr-method}
\alias{[,propr,ANY,ANY-method}
\alias{[,propr-method}
\alias{simplify}
\alias{updateCutoffs.propr}
\title{The propr Package}
\usage{
\S4method{show}{propr}(object)

propr(counts, metric = c("rho", "phi", "phs", "cor"), ivar = "clr", select,
  symmetrize = FALSE, alpha, p = 100)

phit(counts, ...)

perb(counts, ...)

phis(counts, ...)

corr(counts, ...)

\S4method{subset}{propr}(x, subset, select)

\S4method{[}{propr,ANY,ANY}(x, i = "all", j, tiny = FALSE)

simplify(object)

updateCutoffs.propr(object, cutoff = seq(0.05, 0.95, 0.3))
}
\arguments{
\item{object}{A \code{propr} or \code{propd} object.}

\item{counts}{A data.frame or matrix. A "count matrix" with
subjects as rows and features as columns.}

\item{metric}{A character string. The proportionality metric
to calculate. Choose from "rho", "phi", or "phs".}

\item{ivar}{A numeric scalar. Specifies reference feature(s)
for additive log-ratio transformation. The argument will also
accept feature name(s) instead of the index position(s).
Set to "iqlr" to use inter-quartile log-ratio transformation.
Ignore to use centered log-ratio transformation.}

\item{select}{Optional. Use this to subset the final
proportionality matrix without altering the result.
Use this argument to rearrange feature order.}

\item{symmetrize}{A logical. If \code{TRUE}, forces symmetry
by reflecting the "lower left triangle".}

\item{alpha}{A double. See vignette for details. Leave missing
to skip Box-Cox transformation.}

\item{p}{An integer. The number of permutation cycles.}

\item{...}{Arguments passed to the wrapped method.}

\item{x}{A \code{propr} or \code{propd} object.}

\item{subset}{Subsets via \code{object@counts[subset, ]}.
Use this argument to rearrange subject order.
For backwards compatibility.}

\item{i}{Operation used for the subset indexing. Select from
"==", "=", ">", ">=", "<", "<=", "!=", or "all".
For backwards compatibility.}

\item{j}{Provide a numeric value to which to compare the
proportionality measures in the \code{@matrix} slot.
For backwards compatibility.}

\item{tiny}{A logical scalar. Toggles whether to pass the indexed
result through \code{\link{simplify}}.
For backwards compatibility.}

\item{cutoff}{For \code{updateCutoffs}, a numeric vector.
this argument provides the FDR cutoffs to test.
For graph functions, a numeric scalar. This argument
indicates the maximum theta to include in the figure.
For graph functions, a large integer will instead
retrieve the top N pairs as ranked by theta.}
}
\value{
Returns a \code{propr} object.
}
\description{
Welcome to the \code{propr} package!

To learn more about calculating proportionality, see
 Details.

To learn more about visualizing proportionality, see
 \code{\link{visualize}}.

To learn more about \code{ALDEx2} package integration, see
 \code{\link{aldex2propr}}.

To learn more about differential proportionality, see
 \code{\link{propd}}.

To learn more about compositional data analysis, and its relevance
 to biological count data, see the bundled vignette.
}
\details{
Let D represent a number of features measured across N samples.
	This function calculates proportionality from
	a data set with N rows and D columns.
 One can think of phi as
	analogous to a distance matrix, except that it has no symmetry unless forced.
	One can think of rho as
	analogous to a correlation matrix.
	One can think of phs as
	either a naturally symmetric variant of phi or a monotonic variant of rho.
	Also, one can use \code{corr}
	to calculate correlation from log-ratio transformed data.

This function depends on a reference and uses the centered log-ratio
 transformation by default. The user may also specify any number of
 features (by index or name) to use as a reference instead.
 Alternatively, \code{ivar = "iqlr"} will transform data using the
 geometric mean of features with variances that fall in the
 inter-quartile range of all per-feature variances (based on
 the \code{ALDEx2} package).

The \code{propr} method calculates proportionality. This fails in
 the setting of zero counts. The \code{propr} method
 will use a Box-Cox transformation to approximate VLR based on
 the parameter \eqn{\alpha}, if provided. We refer the user to
 the vignette for more details.
}
\section{Slots}{

\describe{
\item{\code{counts}}{A data.frame. Stores the original "count matrix" input.}

\item{\code{alpha}}{A double. Stores the alpha value used for transformation.}

\item{\code{metric}}{A character string. The metric used to calculate proportionality.}

\item{\code{ivar}}{A vector. The reference used to calculate proportionality.}

\item{\code{logratio}}{A data.frame. Stores the transformed "count matrix".}

\item{\code{matrix}}{A matrix. Stores the proportionality matrix.}

\item{\code{pairs}}{A vector. Indexes the proportional pairs of interest.}

\item{\code{results}}{A data.frame. Stores the pairwise \code{propr} measurements.}

\item{\code{permutes}}{A list. Stores the shuffled transformed "count matrix"
instances, used to reproduce permutations of \code{propr}.}

\item{\code{fdr}}{A data.frame. Stores the FDR cutoffs for \code{propr}.}
}}

\section{Methods (by generic)}{

\code{show:} Method to show \code{propr} object.


\code{subset:} Method to subset \code{propr} object.


\code{[:} Method to subset \code{propr} object.
}

\section{Functions}{

\code{phit:}
 A wrapper for \code{propr(counts, metric = "phi", ...)}.


\code{perb:}
 A wrapper for \code{propr(counts, metric = "rho", ...)}.


\code{phis:}
 A wrapper for \code{propr(counts, metric = "phs", ...)}.


\code{corr:}
 A wrapper for \code{propr(counts, metric = "cor", ...)}.


\code{simplify:}
 This convenience function takes an indexed \code{propr} object
 and subsets the object based on that index. Then, it populates the
 \code{@pairs} slot of the new object with an updated version
 of the original index. You can call \code{simplify} from within the
 \code{[} method using the argument \code{tiny}.


\code{updateCutoffs:}
 Use the \code{propr} object to permute proportionality
 across a number of cutoffs. Since the permutations get saved
 when the object is created, calling \code{updateCutoffs}
 will use the same random seed each time.
}

