% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/421.p-Confidence_p-Bias_CC_All.R
\name{pCOpBICAS}
\alias{pCOpBICAS}
\title{p-Confidence and p-Bias estimation for continuity corrected ArcSine method}
\usage{
pCOpBICAS(n, alp, c)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{c}{- Continuity correction}
}
\value{
A dataframe with
 \item{x1}{  Number of successes (positive samples)}
 \item{pconf }{   p-Confidence}
 \item{pbias }{   p-Bias}
}
\description{
p-Confidence and p-Bias estimation for continuity corrected ArcSine method
}
\details{
Evaluation of continuity corrected Wald-type interval for the arcsine
transformation of the parameter \code{p} using p-confidence and p-bias for the  \eqn{n + 1} intervals
}
\examples{
n=5; alp=0.05;c=1/(2*n)
pCOpBICAS(n,alp,c)
}
\references{
[1] 2005 Vos PW and Hudson S.
Evaluation Criteria for Discrete Confidence Intervals: Beyond Coverage and Length.
The American Statistician: 59; 137 - 142.
}
\seealso{
Other p-confidence and p-bias of continuity corrected methods: \code{\link{PlotpCOpBICAS}},
  \code{\link{PlotpCOpBICAll}},
  \code{\link{PlotpCOpBICLT}}, \code{\link{PlotpCOpBICSC}},
  \code{\link{PlotpCOpBICTW}}, \code{\link{PlotpCOpBICWD}},
  \code{\link{pCOpBICAll}}, \code{\link{pCOpBICLT}},
  \code{\link{pCOpBICSC}}, \code{\link{pCOpBICTW}},
  \code{\link{pCOpBICWD}}
}

