% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/328.Sum_Leng_GENERAL_SIM.R
\name{PlotlengthGEN}
\alias{PlotlengthGEN}
\title{Plots the sum of lengths for a specific LL and UL}
\usage{
PlotlengthGEN(n, LL, UL, hp)
}
\arguments{
\item{n}{- Number of trials}

\item{LL}{- Lower limit}

\item{UL}{- Upper limit}

\item{hp}{- Hypothetical "p"}
}
\description{
Plots the sum of lengths for a specific LL and UL
}
\details{
Plot of intervals obtained from any method using sum
of the lengths for the \eqn{n + 1} intervals
}
\examples{
n= 5;
LL=c(0,0.01,0.0734,0.18237,0.3344,0.5492)		#Lower and Upper Limits
UL=c(0.4507,0.6655,0.8176,0.9265,0.9899,1)
hp=seq(0,1,by=0.01)
PlotlengthGEN(n,LL,UL,hp)
}
\seealso{
Other Expected length: \code{\link{PlotexplGEN}},
  \code{\link{PlotexplSIM}}, \code{\link{PlotlengthSIM}},
  \code{\link{lengthGEN}}, \code{\link{lengthSIM}}
}

