% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prophet.R
\name{add_regressor}
\alias{add_regressor}
\title{Add an additional regressor to be used for fitting and predicting.}
\usage{
add_regressor(m, name, prior.scale = NULL, standardize = "auto")
}
\arguments{
\item{m}{Prophet object.}

\item{name}{String name of the regressor}

\item{prior.scale}{Float scale for the normal prior. If not provided,
holidays.prior.scale will be used.}

\item{standardize}{Bool, specify whether this regressor will be standardized
prior to fitting. Can be 'auto' (standardize if not binary), True, or
False.}
}
\value{
The prophet model with the regressor added.
}
\description{
The dataframe passed to `fit` and `predict` will have a column with the
specified name to be used as a regressor. When standardize='auto', the
regressor will be standardized unless it is binary. The regression
coefficient is given a prior with the specified scale parameter.
Decreasing the prior scale will add additional regularization. If no
prior scale is provided, holidays.prior.scale will be used.
}

