% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawModel.R
\name{drawModel}
\alias{drawModel}
\title{Draw statistical diagram with an object of class lavaan or a list of class lm}
\usage{
drawModel(
  semfit = NULL,
  labels = NULL,
  equation = NULL,
  vars = list(),
  moderator = list(),
  covar = NULL,
  data = NULL,
  nodelabels = NULL,
  arrowslabels = NULL,
  whatLabel = "name",
  mode = 1,
  nodemode = 1,
  xmargin = 0.02,
  radx = NULL,
  ymargin = 0.02,
  xlim = NULL,
  ylim = NULL,
  box.col = "white",
  palette = NULL,
  reverse = FALSE,
  rady = 0.06,
  maxypos = NULL,
  minypos = 0,
  ypos = c(1, 0.5),
  mpos = c(0.5, 0.9),
  xinterval = NULL,
  yinterval = NULL,
  xspace = NULL,
  node.pos = list(),
  arrow.pos = list(),
  interactionFirst = FALSE,
  totalOnly = FALSE,
  parallel = FALSE,
  parallel2 = FALSE,
  parallel3 = FALSE,
  kmediator = FALSE,
  serial = FALSE,
  bmatrix = NULL,
  label.pos = 1,
  curved.arrow = list(),
  segment.arrow = list(),
  digits = 3,
  showPos = FALSE,
  drawCovar = TRUE,
  drawbox = FALSE
)
}
\arguments{
\item{semfit}{An object of class lavaan or a list of class lm}

\item{labels}{list of variable names}

\item{equation}{Optional string contains equation}

\item{vars}{A list}

\item{moderator}{A list}

\item{covar}{A list}

\item{data}{A data.frame}

\item{nodelabels}{list of nodes names}

\item{arrowslabels}{list of arrows names}

\item{whatLabel}{What should the edge labels indicate in the path diagram? Choices are c("est","name","estSE")}

\item{mode}{integer If 1, models with categorical X}

\item{nodemode}{integer If 1, separate node name and node label}

\item{xmargin}{horizontal margin between nodes}

\item{radx}{horizontal radius of the box.}

\item{ymargin}{vertical margin between nodes}

\item{xlim}{the x limits (min,max) of the plot}

\item{ylim}{the y limits (min,max) of the plot}

\item{box.col}{fill color of the box}

\item{palette}{character. palette name}

\item{reverse}{logical. Reverse palette or not.}

\item{rady}{vertical radius of the box.}

\item{maxypos}{maximal y position of X or W variables}

\item{minypos}{minimal y position of X or W variables}

\item{ypos}{The x and y position of Y node. Default value is c(1,0.5)}

\item{mpos}{The x and y position of M node. Default value is c(0.5,0.9)}

\item{xinterval}{numeric. Horizontal intervals among labels for nodes and nodes}

\item{yinterval}{numeric. Vertical intervals among labels for nodes and nodes}

\item{xspace}{numeric. Horizontal distance between nodes}

\item{node.pos}{Optional list of node position}

\item{arrow.pos}{Optional list of arrow label position}

\item{interactionFirst}{logical If true, place nodes with interaction first}

\item{totalOnly}{logical If true, draw total effect model only}

\item{parallel}{logical If true, draw parallel multiple mediation model}

\item{parallel2}{logical If true, draw parallel2 multiple mediation model}

\item{parallel3}{logical If true, draw parallel3 multiple mediation model}

\item{kmediator}{logical If true, draw parallel multiple mediation model with k mediator}

\item{serial}{Logical. If TRUE, serial variables are added}

\item{bmatrix}{integer specifying causal relations among mediators}

\item{label.pos}{Integer Position of nodelabels. Choices are one of 1:2}

\item{curved.arrow}{Optional list of curved arrow}

\item{segment.arrow}{Optional list of curved arrow}

\item{digits}{integer indicating the number of decimal places}

\item{showPos}{logical If true print node position}

\item{drawCovar}{logical If true, draw covariates}

\item{drawbox}{logical If true, draw rectangle}
}
\description{
Draw statistical diagram with an object of class lavaan or a list of class lm
}
\examples{
library(lavaan)
labels=list(X="frame",Y="donate")
drawModel(labels=labels)
drawModel(labels=labels,arrowslabels=list(c="c"))
labels=list(X="frame",W="skeptic",M="justify",Y="donate")
moderator=list(name="skeptic",site=list(c("a","c")))
model=tripleEquation(labels=labels,moderator=moderator,data=disaster)
semfit=sem(model=model,data=disaster)
drawModel(semfit,labels=labels,interactionFirst=TRUE)
labels=list(X="protest",W="sexism",M="respappr",Y="liking")
moderator=list(name="sexism",site=list(c("a","c")))
data1=addCatVars(protest,"protest",mode=3)
model=catMediation(X="protest",M="respappr",Y="liking",moderator=moderator,data=protest,maxylev=6)
semfit=sem(model,data=data1)
nodelabels=list(D1="Ind.Protest",D2="Col.Protest",W="sexism",M="respappr",Y="liking")
drawModel(semfit,labels=labels,nodelabels=nodelabels,whatLabel="name",
       xlim=c(-0.4,1.3))
drawModel(semfit,labels=labels)
labels=list(X="cyl",M=c("am","wt","hp"),Y="mpg",W="vs")
moderator=list(name=c("vs"),site=list(c("a1","b1")))
model=multipleMediation(labels=labels,moderator=moderator,data=mtcars)
semfit=sem(model=model,data=mtcars)
drawModel(semfit,labels=labels,maxypos=0.5)
labels=list(X="X",M=c("M1","M2","M3"),Y="Y")
nodelabels=c(X="Intervention\n(vs.control)",
   M=c("Restrained\nEating","Emotional\nEating","Perceived\nBarriers to\nExercise"),Y="Weight Loss")
drawModel(labels=labels,nodelabels=nodelabels,whatLabel="none",parallel=TRUE,
ylim=c(-0.3,1.2),label.pos=2)
labels=list(X="X",M=c("M1","M2","Mk-1","Mk"),Y="Y")
drawModel(labels=labels,parallel=TRUE,kmediator=TRUE,nodemode=2,
    arrow.pos=list(c=0.4),serial=FALSE,radx=0.08)
labels=list(X="cond",M=c("import","pmi"),Y="reaction")
drawModel(labels=labels,parallel=TRUE)
drawModel(labels=labels,parallel=TRUE,serial=TRUE)
model=multipleMediation(labels=labels,data=pmi,serial=TRUE)
model=multipleMediation(labels=labels,data=pmi)
cat(model)
semfit=sem(model=model,data=pmi)
drawModel(semfit,labels=labels,parallel=TRUE)
drawModel(semfit,labels=labels,whatLabel="est",parallel=TRUE)
labels=list(X="X",M=c("M1","M2"),Y="Y")
drawModel(labels=labels,serial=TRUE,nodemode=4)
labels=list(X="X",M=c("M1","M2","M3"),Y="Y")
drawModel(labels=labels,serial=TRUE)
equation='M1~X
M2~X+M1
M3~X+M1
Y~X+M1+M2+M3'
node.pos=list(X=c(0,0.5),M1=c(0.5,0.5),M2=c(0.75,0.9),M3=c(0.75,0.1),Y=c(1,0.5))
curved.arrow=list(a2=-0.1,a3=0.1,c=-0.15)
drawModel(equation=equation,nodemode=2,node.pos=node.pos,curved.arrow=curved.arrow)
equation='M1~X
M2~X
M3~X
M4~X+M1+M2+M3
Y~X+M1+M2+M3+M4'
node.pos=list(X=c(0,0.5),M1=c(0.35,0.9),M2=c(0.35,0.5),M3=c(0.35,0.1),M4=c(0.7,0.5),Y=c(1,0.5))
curved.arrow=list(a4=0.15,b2=0.15)
segment.arrow=list(c=0.5)
drawModel(equation=equation,nodemode=2,node.pos=node.pos,radx=0.08,curved.arrow=curved.arrow,
segment.arrow=segment.arrow)
labels=list(X="baby",M="wine",Y="tile")
moderator=list(name=c("milk"),site=list("a"))
covar=list(name=c("milk","tent","sand"),site=list(c("Y"),c("M","Y"),c("M","Y")))
drawModel(labels=labels,moderator=moderator,covar=covar,palette="Set3")
}
