% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tripleInteraction.R
\name{makeIndirectEquation}
\alias{makeIndirectEquation}
\title{Make indirect equation}
\usage{
makeIndirectEquation(X, M, temp1, temp2, temp3, moderatorNames,
  range = FALSE, data = NULL, rangemode = 1, probs = c(0.16, 0.5,
  0.84))
}
\arguments{
\item{X}{A character string}

\item{M}{A character string}

\item{temp1}{A character vector}

\item{temp2}{A character vector}

\item{temp3}{A character vector}

\item{moderatorNames}{A character vector}

\item{range}{A logical}

\item{data}{A data.frame}

\item{rangemode}{range mode}

\item{probs}{numeric vector of probabilities with values in [0,1]}
}
\description{
Make indirect equation
}
\examples{
X="negemot";M="ideology"
temp1=c("a1*negemot","a2*sex","a4*negemot*sex","a5*negemot*age","a6*sex*age")
temp2="b1*ideology"
temp3="c1*negemot"
moderatorNames=c("age","sex")
X= "hp";M= "am"
temp1= c("a1*hp","a2*wt","a3*hp:wt")
temp2= "b1*am"
temp3= c("c1*hp","c2*wt","c3*hp:wt")
moderatorNames=c("wt")
X= c("d1","d2");M="am"
temp1=c("a1*d1","a2*d2","a3*wt","a4*d1:wt","a5*d2:wt")
temp2="b1*am"
temp3=c("c1*d1","c2*d2","c3*wt","c4*d1:wt","c5*d2:wt")
cat(makeIndirectEquation(X,M,temp1,temp2,temp3,moderatorNames))
cat(makeIndirectEquation(X,M,temp1,temp2,temp3,moderatorNames,range=TRUE))
}
