% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_shuffle_portfolio.R
\name{add_shuffle_portfolio}
\alias{add_shuffle_portfolio}
\alias{add_shuffle_portfolio}
\title{Add a shuffle portfolio}
\usage{
add_shuffle_portfolio(x, number_solutions = 10L, threads = 1L,
  remove_duplicates = TRUE)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{number_solutions}{\code{integer} number of attempts to generate
different solutions. Defaults to 10.}

\item{threads}{\code{integer} number of threads to use for the generating
the solution portfolio. Defaults to 1.}

\item{remove_duplicates}{\code{logical} should duplicate solutions
be removed? Defaults to \code{TRUE}.}
}
\description{
Generate a portfolio of solutions by randomly reordering the data prior to #' attempting to solve the problem.
}
\details{
This strategy for generating a portfolio of solutions often
  results in different solutions, depending on optimality gap, but may
  return duplicate solutions. In general, this strategy is most effective
  when problems are quick to solve and multiple threads are available for
  solving each problem separately.
}
\examples{
# load data
data(sim_pu_raster, sim_features)

# create problem
p <- problem(sim_pu_raster, sim_features) \%>\%
     add_min_set_objective() \%>\%
     add_relative_targets(0.2) \%>\%
     add_shuffle_portfolio(10, remove_duplicates = FALSE) \%>\%
     add_default_solver(gap = 0.2, verbose = FALSE)

\donttest{
# solve problem and generate 10 solutions within 20 \% of optimality
s <- solve(p)

# plot solution
plot(s, axes = FALSE, box = FALSE)
}

}
\seealso{
\code{\link{portfolios}}.
}
