% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulationsfunctions.R
\name{simulate_pps_data}
\alias{simulate_pps_data}
\title{Function to simulate PPS data}
\usage{
simulate_pps_data(n.sample, steps, hospital)
}
\arguments{
\item{n.sample}{number of beds to simulate}

\item{steps}{number of steps to evolve the process}

\item{hospital}{type of hospital as a list-object (see vignette for details)}
}
\value{
data frame with following columns \itemize{
   \item{A.loi - length of infection up to PPS}
   \item{L.loi - total length of infection}
   \item{A.los - length of stay up to PPS}
   \item{L.los - total length of stay}
   \item{patient.type - patient type}
}
}
\description{
Simulates PPS data for a prespecified hospital according to a steady state model of
incidence ( see vignette "Overview of prevtoinc-Package" for details.)
}
\examples{

pat.1 <- list(dist.X.los = 
                   create_dist_vec(function(x) dpois(x-1, lambda = 12), 70),
              I.p = 0.008,
              dist.X.loi = 
                   create_dist_vec(function(x) dpois(x-1, lambda = 10), 70))

pat.2 <- list(dist.X.los = 
                   create_dist_vec(function(x) dpois(x-1, lambda = 10), 70),
              I.p = 0.02,
              dist.X.loi =
                   create_dist_vec(function(x) dpois(x-1, lambda = 7), 70))

patient.list <- list(pat.1, pat.2)


# define distribution of patients
pat.1.prob <- 0.4; pat.2.prob <- 0.6
pat.dist.hosp <- c(pat.1.prob, pat.2.prob)
hospital.1 <- list(inc.factor = 1,
                   pat.dist = pat.dist.hosp,
                   patient.list = patient.list)
data.pps <- simulate_pps_data(n.sample=1000, steps=200, hospital=hospital.1)                    

}
