% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimationfunctions.R
\name{X_to_A_dist}
\alias{X_to_A_dist}
\title{Transform a distribution of times of stay to a
distribution of staying-time up to observation point under
assumption of steady state.}
\usage{
X_to_A_dist(dist.stays)
}
\arguments{
\item{dist.stays}{vector of probabilities of being at the
hospital for 1:length(dist.stays) days at random time of
observation}
}
\value{
vector of probabilities of staying
1:length(dist.point) days
}
\description{
Transform a distribution of times of stay to a
distribution of staying-time up to observation point under
assumption of steady state.
}
\examples{

# generate vector of probabilities for truncated Poisson distribution for 
# distribution of times of stay X
dist.X <- dpois(1:70, 4)
plot(dist.X)
# transform to distribution of distribution of staying-time up to observation point under
# assumption of steady state
dist.A <- X_to_A_dist(dist.X)
plot(dist.A)
# transform back to get original distribution
dist.X.2 <- A_to_X_dist(dist.A)
plot(dist.X.2)

}
