% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_measures.R
\name{prec_kappa}
\alias{prec_kappa}
\title{Sample size or precision for Cohen's kappa}
\usage{
prec_kappa(
  kappa,
  n = NULL,
  raters = 2,
  n_category = 2,
  props,
  conf.width = NULL,
  conf.level = 0.95
)
}
\arguments{
\item{kappa}{expected value of Cohen's kappa.}

\item{n}{sample size.}

\item{raters}{number of raters (maximum of 6).}

\item{n_category}{number of categories of outcomes (maximum of 5).}

\item{props}{expected proportions of each outcome (should have length
\code{n_category}).}

\item{conf.width}{precision (the full width of the confidence interval).}

\item{conf.level}{confidence level.}
}
\value{
Object of class "presize", a list of arguments (including the
  computed one) augmented with method and note elements.
}
\description{
\code{prec_kappa} returns the sample size or the precision for the provided Cohen's kappa coefficient.
}
\details{
This function wraps the \code{FixedN} and \code{CI} functions in the
\code{kappaSize} package.
The \code{FixedN} functions in \code{kappaSize} return a one sided confidence
interval. The values that are passed to \code{kappaSize} ensure that two-sided
confidence intervals are returned, although we assume that confidence intervals
are symmetrical.
}
\examples{
# precision based on sample size
#   two categories with proportions of 30 and 70\\%, four raters
prec_kappa(kappa = .5, n = 200, raters = 4, n_category = 2, props = c(.3,.7))
# sample size to get a given precision
prec_kappa(kappa = .5, conf.width = .15, raters = 4, n_category = 2,
           props = c(.3,.7))

# as above, but with two scenarios for kappa
prec_kappa(kappa = c(.5, .75), conf.width = .15, raters = 4, n_category = 2,
           props = c(.3,.7))
prec_kappa(kappa = c(.5, .75), conf.width = c(.15, 0.3), raters = 4,
           n_category = 2, props = c(.3,.7))

}
\seealso{
\code{\link[kappaSize]{FixedNBinary}},
\code{\link[kappaSize]{FixedN3Cats}},
\code{\link[kappaSize]{CIBinary}},
\code{\link[kappaSize]{CI3Cats}}
}
