% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_predint.R
\name{boot_predint}
\alias{boot_predint}
\title{Bootstrap new data from uncalibrated prediction intervals}
\usage{
boot_predint(pred_int, nboot)
}
\arguments{
\item{pred_int}{object of class \code{c("quasiPoissonPI", "betaBinomialPI",
"quasiBinomialPI", negativeBinomialPI)}}

\item{nboot}{number of bootstraps}
}
\value{
\code{boot_predint} returns an object of class \code{c("predint", "bootstrap")}
which is a list with two entries: One for bootstrapped historical observations
and one for bootstrapped future observations.
}
\description{
\code{boot_predint()} is a helper function to bootstrap new data from the simple
uncalibrated prediction intervals implemented in predint.
}
\details{
This function only works for binomial and Poisson type data. For the sampling
of new data from random effects models see \code{\link{lmer_bs}}.
}
\examples{
# Simple quasi-Poisson PI
test_pi <- qp_pi(histoffset=c(3,3,3,4,5), newoffset=3, lambda=10, phi=3, q=1.96)

# Draw 5 bootstrap samles
test_boot <- boot_predint(pred_int = test_pi, nboot=50)
str(test_boot)
summary(test_boot)

# Please note that the low number of bootstrap samples was chosen in order to
# decrease computing time. For valid analysis draw at least 10000 bootstrap samples.

}
