% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.predint.R
\name{as.data.frame.predint}
\alias{as.data.frame.predint}
\title{Store prediction intervals or limits as a \code{data.frame}}
\usage{
\method{as.data.frame}{predint}(x, ...)
}
\arguments{
\item{x}{object of class \code{predint}}

\item{...}{additional arguments to be passed to \code{base::as.data.frame()}}
}
\value{
This function returns the prediction intervals or limits stored in an
object of class \code{"predint"} as a \code{data.frame}
}
\description{
Get the prediction intervals or limits of an object of class \code{predint} and
save them as a \code{data.frame}.
}
\examples{
### PI for quasi-Poisson data
\donttest{pred_int <- quasi_pois_pi(histdat=data.frame(qp_dat1),
                          newoffset=c(1,2,3),
                          nboot=100,
                          traceplot = FALSE)

# Return the prediction intervals as a data.frame
as.data.frame(pred_int)}
}
