% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{plot.pre}
\alias{plot.pre}
\title{Plot method for class pre}
\usage{
\method{plot}{pre}(
  x,
  penalty.par.val = "lambda.1se",
  linear.terms = TRUE,
  nterms = NULL,
  fill = "white",
  ask = FALSE,
  exit.label = "0",
  standardize = FALSE,
  plot.dim = c(3, 3),
  ...
)
}
\arguments{
\item{x}{an object of class \code{\link{pre}}.}

\item{penalty.par.val}{character or numeric. Value of the penalty parameter
\eqn{\lambda} to be employed for selecting the final ensemble. The default
\code{"lambda.min"} employs the \eqn{\lambda} value within 1 standard
error of the minimum cross-validated error. Alternatively, 
\code{"lambda.min"} may be specified, to employ the \eqn{\lambda} value
with minimum cross-validated error, or a numeric value \eqn{>0} may be 
specified, with higher values yielding a sparser ensemble. To evaluate the 
trade-off between accuracy and sparsity of the final ensemble, inspect
\code{pre_object$glmnet.fit} and \code{plot(pre_object$glmnet.fit)}.}

\item{linear.terms}{logical. Should linear terms be included in the plot?}

\item{nterms}{numeric. The total number of terms (or rules, if 
\code{linear.terms = FALSE}) being plotted. Default is \code{NULL}, 
resulting in all terms of the final ensemble to be plotted.}

\item{fill}{character of length 1 or 2. Background color(s) for terminal 
panels. If one color is specified, all terminal panels will have the 
specified background color. If two colors are specified (the default, the 
first color will be used as the background color for rules with a positively 
valued coefficient; the second color for rules with a negatively valued 
coefficient.}

\item{ask}{logical. Should user be prompted before starting a new page of
plots?}

\item{exit.label}{character string. Label to be printed in nodes to which 
the rule does not apply (``exit nodes'')?}

\item{standardize}{logical. Should printed importances be standardized? See
\code{\link{importance.pre}}.}

\item{plot.dim}{integer vector of length two. Specifies the number of rows
and columns in the plot. The default yields a plot with three rows and three 
columns, depicting nine baselearners per plotting page.}

\item{...}{Arguments to be passed to \code{\link[grid]{gpar}}.}
}
\description{
\code{plot.pre} creates one or more plots depicting the rules in the final
ensemble as simple decision trees.
}
\examples{
\donttest{set.seed(42)
 airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),])
 plot(airq.ens)}
}
\seealso{
\code{\link{pre}}, \code{\link{print.pre}}
}
