% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova1way.F.unbal.R
\name{anova1way.F.unbal}
\alias{anova1way.F.unbal}
\title{Power calculation for unbalanced one-way analysis of variance omnibus F test}
\usage{
anova1way.F.unbal(
  nvec = NULL,
  mvec = NULL,
  sd = NULL,
  Rsq = 0,
  ncov = 0,
  alpha = 0.05,
  v = FALSE
)
}
\arguments{
\item{nvec}{A vector of group sample sizes c(n1, n2, ...).}

\item{mvec}{A vector of group mvec c(mu1, mu2, ...).}

\item{sd}{The estimated standard deviation within each group.}

\item{Rsq}{The estimated R^2 for regressing the outcome on the covariates; defaults to 0.}

\item{ncov}{The number of covariates adjusted for in the model; defaults to 0.}

\item{alpha}{The significance level or type 1 error rate; defaults to 0.05.}

\item{v}{Either TRUE for verbose output or FALSE to output computed argument only.}
}
\value{
A list of the arguments (including the computed power).
}
\description{
Performs power calculation for an unbalanced (unequal group sizes)
one-way ANOVA omnibus F test, which tests for any differences among group means.
This function solves for power given other parameters. For balanced data
(equal-sized groups), anova1way.F.bal can be used and solves for more
parameters.
}
\examples{
anova1way.F.unbal(nvec = c(10, 20, 30), mvec = c(5, 10, 12), sd = 10)
}
