% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMS.R
\name{LMS}
\alias{LMS}
\title{Latent moderated strctured equations by Klein and Moosbrugger (2000), the ML approach to nonlinear SEM}
\usage{
LMS(
  lavModel_Analysis,
  data,
  data_transformations = NULL,
  prefix = 1,
  pathLMS = tempdir(),
  algorithm = "INTEGRATION"
)
}
\arguments{
\item{lavModel_Analysis}{the lavModel_Analysis object}

\item{data}{set to fit}

\item{data_transformations}{Object containing info on possible data transformations.}

\item{prefix}{an arbitrary prefix for the data set. This prevents issues when using parallelization and Mplus.}

\item{pathLMS}{path where (temporal) data and scripts for running LMS using Mplus are stored (using \code{MplusAutomation}). Default to \code{NULL}, then \code{tempdir()} is used.}

\item{algorithm}{algorithm to use. Default to INTEGRATION.}
}
\value{
Returns a \code{data.frame} that includes parameter estimates estimated using LMS.
}
\description{
Latent moderated strctured equations by Klein and Moosbrugger (2000), the ML approach to nonlinear SEM
}
\references{
Klein, A. G., & Moosbrugger, H. (2000). Maximum likelihood estimation of latent interaction effects with the LMS method. \emph{Psychometrika, 65}(4), 457–474. \doi{10.1007/BF02296338}
}
