% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drpn.R, R/prpn.R, R/qrpn.R, R/rrpn.R
\name{revpn}
\alias{revpn}
\alias{drpn}
\alias{revpn}
\alias{prpn}
\alias{revpn}
\alias{qrpn}
\alias{revpn}
\alias{rrpn}
\title{The Reversal Power Normal Distribution}
\usage{
drpn(x, lambda = 1, mu = 0, sigma = 1, log = FALSE)

prpn(q, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

qrpn(p, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

rrpn(n, lambda = 1, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the reversal power normal distribution with parameters mu, sigma and lambda.
}
\details{
The reversal power Normal distribution has density

\eqn{f\left(x\right)=\frac{\lambda}{\sigma}\left[\frac{e^{-\left(\frac{x-\mu}{\sigma}\right)^{2}}}{\sqrt{2\pi}}\right]\left[\Phi\left(-\left(\frac{x-\mu}{\sigma}\right)\right)\right]^{\lambda-1}}{f(x)=[\lambda/\sigma][exp(-((x-\mu)/\sigma)^2)/\sqrt(2\pi)][\Phi(-(x-\mu)/\sigma)]^(\lambda-1)},

where \eqn{-\infty<\mu<\infty} is the location paramether, \eqn{\sigma^2>0} the scale parameter and \eqn{\lambda>0} the shape parameter.
}
\examples{
drpn(1, 1, 3, 4)
prpn(1, 1, 3, 4)
qrpn(0.2, 1, 3, 4)
rrpn(5, 2, 3, 4)
}
\references{
Anyosa, S. A. C. (2017) \emph{Binary regression using power and reversal power links}. Master's thesis in Portuguese. Interinstitutional Graduate Program in Statistics. Universidade de São Paulo - Universidade Federal de São Carlos. Available in \url{http://conteudo.icmc.usp.br/pessoas/jlbazan/download/thesis.pdf}.

Bazán, J. L., Torres -Avilés, F., Suzuki, A. K. and Louzada, F. (2017) Power and reversal power links for binary regressions: An application for motor insurance policyholders. \emph{Applied Stochastic Models in Business and Industry}, \strong{33}(1), 22-34.

Bazán, J. L., Romeo, J. S. and Rodrigues, J. (2014) Bayesian skew-probit regression for binary response data. \emph{Brazilian Journal of Probability and Statistics}. \strong{28}(4), 467–482.
}
