df <- data.frame(stringsAsFactors = FALSE,
                 requestYear = c(2015, 2013, 2012, 2011, 2010, 2008, 2005, 2002, 1999, 1996,
                                 1993, 1990, 1987, 1984, 1981),
                 regionTitle = c("XX", "XX", "XX", "XX", "XX", "XX", "XX", "XX", "XX", "XX",
                                 "XX", "XX", "XX", "XX", "XX"),
                 regionCID = c("XX", "XX", "XX", "XX", "XX", "XX", "XX", "XX", "XX", "XX",
                               "XX", "XX", "XX", "XX", "XX"),
                 povertyLine = c(1.9, 1.9, 1.9, 1.9, 1.9, 1.9, 1.9, 1.9, 1.9, 1.9, 1.9, 1.9,
                                 1.9, 1.9, 1.9),
                 mean = c(331.9518, 287.878, 255.9578, 234.3553, 218.4931, 186.0266,
                          151.1218, 116.2605, 91.69637, 83.46693, 65.90376, 56.79037,
                          57.44738, 46.90331, 35.46833),
                 hc = c(0.00727083, 0.0185419, 0.0646885, 0.07895739, 0.1116049,
                        0.1479918, 0.1847085, 0.3158984, 0.4011469, 0.4156777,
                        0.5650601, 0.6603551, 0.6025031, 0.7498528, 0.8783229),
                 pg = c(0.001551545, 0.003517289, 0.01374865, 0.01762504,
                        0.02652531, 0.03924656, 0.0483659, 0.1006844, 0.1302443,
                        0.1283172, 0.2028744, 0.2403289, 0.2140888, 0.2876525,
                        0.4255611),
                 p2 = c(0.0007187587, 0.001326342, 0.004559038, 0.006073986,
                        0.009166014, 0.01485398, 0.01801385, 0.04285051, 0.05647545,
                        0.05343351, 0.09457344, 0.1125605, 0.1022324, 0.1406076,
                        0.2424055),
                 population = c(1374.100703, 1360.275092, 1353.595401, 1347.035195,
                                1340.618021, 1327.602314, 1306.731487, 1283.45101,
                                1255.843778, 1220.718033, 1181.667287, 1138.471542, 1087.118605,
                                1039.729429, 996.611056)
)

test_that("Aggregate data are correctly formatted", {
  out <- format_data_aggregate(df)
  expected_names <- c("regiontitle", "regioncode", "year",
                      "povertyline", "mean", "headcount", "povertygap",
                      "povertygapsq", "population")
  expect_equal(names(out), expected_names)
}
)
