% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/povcalnet_cl.R
\name{povcalnet_cl}
\alias{povcalnet_cl}
\title{povcalnet_cl
Facilitate interaction with the PovcalNet API. All parameters are specified
at the country level (hence the _cl suffix), so if you send a request for two
countries, you must also pass two values to the `year` argument, two values
to the `povline` argument, etc.}
\usage{
povcalnet_cl(country, povline, year, coverage = NULL, ppp = NULL,
  url = "http://iresearch.worldbank.org", format = "csv")
}
\arguments{
\item{country}{character: list of country iso3 code (accepts multiple).
Use \code{\link{povcalnet_info}} for full list of countries.}

\item{povline}{numeric: poverty line (in 2011 PPP-adjusted USD) to
calculate poverty measures}

\item{year}{numeric:  list of years, or `all`, or `last`.}

\item{coverage}{character: Can take one of three values: `national`, `urban`, `rural`}

\item{ppp}{numeric: Optional - Allows the selection of custom PPP (Purchasing Power Parity) exchange rates}

\item{url}{character: API root URL. For testing purposes only, should not be
changed for 99 percent of users.}

\item{format}{character: Response format to be requested from the API:
`csv` or `json`}
}
\value{
data.frame
}
\description{
povcalnet_cl
Facilitate interaction with the PovcalNet API. All parameters are specified
at the country level (hence the _cl suffix), so if you send a request for two
countries, you must also pass two values to the `year` argument, two values
to the `povline` argument, etc.
}
\examples{
\donttest{
povcalnet_cl(country = c("ALB", "USA"), povline = c(3.2, 5.5), year = c(2012, 2010))
}
}
