% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods4PostHoc.R
\name{barplot.PostHoc}
\alias{barplot.PostHoc}
\title{Barplot method for objects of class PostHoc}
\usage{
\method{barplot}{PostHoc}(
  height,
  col = "lightblue",
  labelsCol = "black",
  space2max = 0,
  UseGrouping = TRUE,
  ylim = NULL,
  main = "",
  ylab = "",
  xlab = "",
  lty = 1,
  drawAxis = TRUE,
  rightshift = 0,
  additionalTextGrouping = "",
  superpose = FALSE,
  cex.grouping = 1,
  cex.ticks = 0.1,
  cex.lab = 1,
  ylog = FALSE,
  ...
)
}
\arguments{
\item{height}{an object of class PostHoc to be printed}

\item{col}{the colour of the bars (default = "lightblue")}

\item{labelsCol}{the colour of the bars (default = "black")}

\item{space2max}{space between the upper limit of the confidence interval and the label¨}

\item{UseGrouping}{should the grouping be added to the plots (default = TRUE)}

\item{ylim}{range of the vertical axis}

\item{main}{character with the title of the plot (default = '')}

\item{ylab}{label of the vertical axis}

\item{xlab}{label of the horizontal axis}

\item{lty}{type of line}

\item{drawAxis}{should the axis be drawn (default = TRUE)}

\item{rightshift}{a number specifying a (small) right shift of the line}

\item{additionalTextGrouping}{character vector with additional text to the grouping}

\item{superpose}{should the graph be superposed to an existing graph (default = FALSE)}

\item{cex.grouping}{size of the labels of groups}

\item{cex.ticks}{size of the thicks defining the the limits of the confidence intervals}

\item{cex.lab}{size of the labels}

\item{ylog}{should the vertical axis be expressed in a logarithmic scale (default = FALSE)}

\item{...}{parameters to be passed to the barlot function}
}
\value{
none
}
\description{
Barplot method for objects of class PostHoc
}
\examples{
MM <- glm(Y ~ Treatment+0,  data=DeIdentifiedExample)
GG <- posthoc(MM)
barplot(GG)
}
\author{
Rodrigo Labouriau
}
