% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portion.R
\name{portion}
\alias{portion}
\alias{portion.numeric}
\alias{portion.character}
\alias{portion.logical}
\alias{portion.matrix}
\alias{portion.data.frame}
\alias{portion.list}
\title{Extracting a data portion}
\usage{
portion(x, proportion, how = "random", centers = 2L, ...)

\method{portion}{numeric}(x, proportion, how = "random", centers = 2L, ...)

\method{portion}{character}(x, proportion, how = "random", ...)

\method{portion}{logical}(x, proportion, how = "random", centers = 2L, ...)

\method{portion}{matrix}(
  x,
  proportion,
  how = "random",
  centers = 2L,
  byrow = TRUE,
  ignore = integer(),
  ...
)

\method{portion}{data.frame}(
  x,
  proportion,
  how = "random",
  centers = 2L,
  byrow = TRUE,
  ignore = integer(),
  ...
)

\method{portion}{list}(x, proportion, how = "random", centers = 2L, ...)
}
\arguments{
\item{x}{An object to be portioned.}

\item{proportion}{[\code{numeric(1)}]\cr
The relative portion size between \code{0} and \code{1} (rounded up).}

\item{how}{[\code{character(1)}]\cr
Specifying how to portion, one of:
\itemize{
\item \code{"random"} (default), portion at random
\item \code{"first"}, portion to the first elements
\item \code{"last"}, portion to the last elements
\item \code{"similar"}, portion to similar elements
\item \code{"dissimilar"}, portion to dissimilar elements
}

Options \code{"similar"} and \code{"dissimilar"} are based on clustering via
\code{\link[stats]{kmeans}} and hence are only available for numeric \code{x}.}

\item{centers}{[\code{integer(1)}]\cr
Only relevant if \code{how = "similar"} or \verb{how = "dissimilar}.

In this case, passed on to \code{\link[stats]{kmeans}} for clustering.}

\item{...}{Further arguments to be passed to or from other methods.}

\item{byrow}{[\code{logical(1)}]\cr
Only relevant if \code{x} has two dimensions (rows and columns).

In this case, set to \code{TRUE} to portion row-wise (default) or \code{FALSE} to
portion column-wise.}

\item{ignore}{[\code{integer()}]\cr
Only relevant if \code{how = "similar"} or \verb{how = "dissimilar}.

In this case, row indices (or column indices if \code{byrow = FALSE}) to ignore
during clustering.}
}
\value{
The portioned input \code{x} with (row, column) indices as attributes \code{"indices"}.
}
\description{
Methods to extract portions of different objects.
}
\examples{
# can portion vectors, matrices, data.frames, and lists of such types
portion(
  list(
    1:10,
    matrix(LETTERS[1:12], nrow = 3, ncol = 4),
    data.frame(a = 1:6, b = -6:-1)
  ),
  proportion = 0.5,
  how = "first"
)

# can portion similar elements
portion(c(rep(1, 5), rep(2, 5)), proportion = 0.5, how = "similar")
}
