% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_observations}
\alias{download_observations}
\title{Download the PortalData repo}
\usage{
download_observations(
  path = get_default_data_path(),
  version = "latest",
  source = "github",
  quiet = FALSE,
  verbose = FALSE,
  pause = 30,
  timeout = getOption("timeout"),
  force = FALSE
)
}
\arguments{
\item{path}{\code{character} Folder into which data will be downloaded.}

\item{version}{\code{character} Version of the data to download (default = "latest"). If \code{NULL}, returns.}

\item{source}{\code{character} indicator of the source for the download. Either \code{"github"} (default) or \code{"zenodo"}.}

\item{quiet}{\code{logical} whether to download data silently.}

\item{verbose}{\code{logical} whether to provide details of downloading.}

\item{pause}{Positive \code{integer} or integer \code{numeric} seconds for pausing during steps around unzipping that require time delayment.}

\item{timeout}{Positive \code{integer} or integer \code{numeric} seconds for timeout on downloads. Temporarily overrides the \code{"timeout"} option in \code{\link[base]{options}}.}

\item{force}{\code{logical} indicator of whether or not existing files or folders (such as the archive) should be over-written if an up-to-date copy exists (most users should leave as \code{FALSE}).}
}
\value{
NULL invisibly.
}
\description{
Downloads specified version of the Portal data.
}
