% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_ants.R
\name{bait_presence_absence}
\alias{bait_presence_absence}
\title{Ant Bait Presence Absence}
\usage{
bait_presence_absence(path = "~", level = "Site",
  download_if_missing = TRUE)
}
\arguments{
\item{path}{path to location of downloaded Portal data; or "repo" to
retrieve data from github repo}

\item{level}{level at which to summarize data: 'Site', 'Plot', or 'Stake'}

\item{download_if_missing}{if the specified file path doesn't have the
PortalData folder, then download it}
}
\value{
data frame with year, species, (plot if applicable), and presence [1, 0]
}
\description{
Get ant species presence/absence by year/plot/stake from bait census data

Bait census data is more consistent over time than the colony census data. This function assumes that all species
present in at least one census were censused in all years.
}
