% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstraping.R
\name{diversity_stats}
\alias{diversity_stats}
\title{Produce a table of diversity statistics}
\usage{
diversity_stats(z, H = TRUE, G = TRUE, lambda = TRUE, E5 = TRUE, ...)
}
\arguments{
\item{z}{a table of integers representing counts of MLGs (columns) per 
population (rows)}

\item{H}{logical whether or not to calculate Shannon's index}

\item{G}{logical whether or not to calculate Stoddart and Taylor's index (aka
inverse Simpson's index).}

\item{lambda}{logical whether or not to calculate Simpson's index}

\item{E5}{logical whether or not to calculate Evenness}

\item{...}{any functions that can be calculated on a vector or matrix of 
genotype counts.}
}
\value{
a numeric matrix giving statistics (columns) for each population 
  (rows).
}
\description{
Calculate diversity statistics on a matrix containing counts of multilocus
genotypes per population.
}
\details{
This function will calculate any diversity statistic for counts of 
  multilocus genotypes per population. This does not count allelic diversity.
  The calculations of H, G, and lambda are all performed by 
  \code{\link[vegan]{diversity}}. E5 is calculated as \deqn{E_{5} = 
  \frac{(1/\lambda) - 1}{e^{H} - 1}}{(G - 1)/(exp(H) - 1)}.
}
\examples{
library(poppr)
data(Pinf)
tab <- mlg.table(Pinf, plot = FALSE)
diversity_stats(tab)
\dontrun{
# Example using the poweRlaw package to calculate the negative slope of the
# Pareto distribution.

library("poweRlaw")
power_law_beta <- function(x){
  xpow <- displ(x[x > 0])                 # Generate the distribution
  xpow$setPars(estimate_pars(xpow))       # Estimate the parameters
  xdat <- plot(xpow, draw = FALSE)        # Extract the data
  xlm <- lm(log(y) ~ log(x), data = xdat) # Run log-log linear model for slope
  return(-coef(xlm)[2])
}

Beta <- function(x){
  x <- drop(as.matrix(x))
  if (length(dim(x)) > 1){
    res <- apply(x, 1, power_law_beta)
  } else {
    res <- power_law_beta(x)
  }
  return(res)
}

diversity_stats(tab, B = Beta)
}
}
\seealso{
\code{\link{diversity_boot}} \code{\link{diversity_ci}}
  \code{\link{poppr}}
}
\author{
Zhian N. Kamvar
}
