% Generated by roxygen2 (4.0.1): do not edit by hand
\name{genDelMat}
\alias{genDelMat}
\title{Generate delta matrix}
\usage{
genDelMat(theta.diff, sigma.2 = 1, n = 1)
}
\arguments{
\item{theta.diff}{A vector of length p-1, where p is the number of populations
of treatments. Coordinate [i] in theta.diff corresponds to \eqn{\theta_i -
\theta_{i+1}}.}

\item{sigma.2}{The known variance of the error terms.}

\item{n}{The number of replications in each population.}
}
\value{
The function returns a matrix with p rows and p columns, that
contains the \eqn{delta_{ij}}'s, as described in the paper.
}
\description{
This function will generate the matrix of deltas, as specified in the paper.
See Details section.
}
\details{
As specified in the paper, we can assume that the thetas are in a
decreasing order, meaning that \eqn{\theta_1 \ge \theta_2, \ldots, \theta_n}.
It follows that all the components of the theta.diff vector must be positive.
Note that the delta matrix in the paper is a scaled version of the
differences between the thetas.
}
\examples{
del1 <- c(2, 4)
genDelMat(del1)
}
\seealso{
\code{\link{exactCoverageProb}}, \code{\link{integrand}}
}

