
/*
 *<SOURCE_HEADER>
 *
 *  <NAME>
 *    signal-handler.h
 *  </NAME>
 *  <AUTHOR>
 *    Anthony R. Cassandra
 *  </AUTHOR>
 *  <CREATE_DATE>
 *    July, 1998
 *  </CREATE_DATE>
 *
 *  <RCS_KEYWORD>
 *    $RCSfile: signal-handler.h,v $
 *    $Source: /u/cvs/proj/pomdp-solve/src/signal-handler.h,v $
 *    $Revision: 1.1 $
 *    $Date: 2003/05/13 21:46:40 $
 *  </RCS_KEYWORD>
 *
 *  <COPYRIGHT>
 *
 *    1994-1997, Brown University
 *    1998-2003, Anthony R. Cassandra
 *
 *    All Rights Reserved
 *                          
 *    Permission to use, copy, modify, and distribute this software and its
 *    documentation for any purpose other than its incorporation into a
 *    commercial product is hereby granted without fee, provided that the
 *    above copyright notice appear in all copies and that both that
 *    copyright notice and this permission notice appear in supporting
 *    documentation.
 * 
 *    ANTHONY CASSANDRA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 *    INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 *    PARTICULAR PURPOSE.  IN NO EVENT SHALL ANTHONY CASSANDRA BE LIABLE FOR
 *    ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *    WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *    ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 *    OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *  </COPYRIGHT>
 *
 *</SOURCE_HEADER>
 */
#ifndef SIGNAL_HANDLER_H
#define SIGNAL_HANDLER_H

#include "params.h"

/*******************************************************************/
/**************             CONSTANTS               ****************/
/*******************************************************************/

/* Defining this constant turns off the memory limit stuff */
#define DISABLE_MEMORY_LIMIT


/*******************************************************************/
/**************       EXTERNAL VARIABLES            ****************/
/*******************************************************************/

extern int gInterrupt;

/*******************************************************************/
/**************       EXTERNAL FUNCTIONS            ****************/
/*******************************************************************/

/* If the -brief option is specified, then we set a timer for the
   maximum number of seconds we will allow the program to run for.  */
extern void setUpIntervalTimer( int secs );

/* Sets the hard virtual memory size limit.  If process exceeds this
   limit, then the SIGSEGV signal will be generated.  We also try to
   catch this signal, but we are carefull not to assume that every
   SIGSEGV is due to resource limitations.  */
extern void setMemoryLimit( int mem_size_limit );

/* Registers the signal handler for the SIGINT signal which is
  generated by pressing CRTL-C.  */
extern void setUpCtrlC(void);

/* Sets the parameter context so that when interrupts are received we
  can look there for information about where the soluton process
  stoppped.  */
extern void setInterruptParamContext( PomdpSolveParams param );
      
#endif
