% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reward.R
\name{reward}
\alias{reward}
\title{Calculate the Reward for a POMDP Solution}
\usage{
reward(x, belief = NULL, epoch = 1)
}
\arguments{
\item{x}{a solved \link{POMDP} object.}

\item{belief}{specification of the current belief state (see argument start
in \link{POMDP} for details). By default the belief state defined in
the model as start is used.}

\item{epoch}{return reward for this epoch. Default is the first epoch.}
}
\value{
A list with the components
\item{reward}{the total expected reward
given a belief and epoch. }
\item{belief_state}{the belief state specified
in \code{belief}.}
\item{pg_node}{the policy node that represents the belief
state.}
\item{action}{the optimal action.}
}
\description{
This function calculates the expected total reward for a POMDP solution
given a starting belief state.
}
\details{
The value is calculated using the value function stored in the POMDP
solution.
}
\examples{
data("Tiger")
sol <- solve_POMDP(model = Tiger)

# if no start is specified, a uniform belief is used.
reward(sol)

# we have additional information that makes us believe that the tiger
# is more likely to the left.
reward(sol, belief = c(0.85, 0.15))

# we start with strong evidence that the tiger is to the left.
reward(sol, belief = "tiger-left")

# Note that in this case, the total discounted expected reward is greater
# than 10 since the tiger problem resets and another game staring with
# a uniform belief is played which produces additional reward.
}
\seealso{
Other policy: 
\code{\link{optimal_action}()},
\code{\link{plot_policy_graph}()},
\code{\link{plot_value_function}()},
\code{\link{policy_graph}()},
\code{\link{policy}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()}
}
\author{
Michael Hahsler
}
\concept{policy}
