% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSR_methods.R
\name{predict.FSR}
\alias{predict.FSR}
\title{predict.FSR}
\usage{
\method{predict}{FSR}(object, newdata, model_to_use = NULL,
  standardize = NULL, noisy = TRUE, ...)
}
\arguments{
\item{object}{FSR output. Predictions will be made based on object$best_formula unless model_to_use is provided (as an integer).}

\item{newdata}{New Xdata.}

\item{model_to_use}{Integer optionally indicating a model to use if object$best_formula is not selected. Example: model_to_use = 3 will use object$models$formula[3].}

\item{standardize}{Logical--standardize numeric variables? (If NULL, the default, bypasses and decides based on object$standardize.)}

\item{noisy}{Display output?}

\item{...}{ignore}
}
\value{
y_hat (predictions using chosen model estimates).
}
\description{
predict.FSR
}
\examples{
out <- FSR(mtcars[1:30,])
forecast <- predict(out, mtcars[31:nrow(mtcars),])
}
