% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{QTLscan}
\alias{QTLscan}
\title{General QTL function that allows for co-factors, completely randomised block designs and the possibility to derive LOD thresholds using a permutation test}
\usage{
QTLscan(
  IBD_list,
  Phenotype.df,
  genotype.ID,
  trait.ID,
  block = NULL,
  cofactor_df = NULL,
  allelic_interaction = FALSE,
  folder = NULL,
  filename.short,
  prop_Pheno_rep = 0.5,
  perm_test = FALSE,
  N_perm.max = 1000,
  alpha = 0.05,
  gamma = 0.05,
  ncores = 1,
  log = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{IBD_list}{List of IBD probabilities}

\item{Phenotype.df}{A data.frame containing phenotypic values}

\item{genotype.ID}{The colname of \code{Phenotype.df} that contains the offspring identifiers (F1 names)}

\item{trait.ID}{The colname of \code{Phenotype.df} that contains the response variable to use in the model}

\item{block}{The blocking factor to be used, if any (must be colname of \code{Phenotype.df}). By default \code{NULL}, in which case no blocking structure (for unreplicated experiments)}

\item{cofactor_df}{A 3-column data frame of co-factor(s); column 1 gives the numeric linkage group identifier(s), 
column 2 specifies the cM position of the co-factor(s), column 3 specifies whether the QTL was fitted using "a" = additive effects or 
"f" = full allelic interactions (note that any other symbol for the full model will also be accepted, as long as it is not "a"). 
For backward compatibility with package versions <= 0.0.9, it is possible to just supply the first two columns, 
in which case an additive-effects model is assumed for each cofactor (so, a third column will be automatically filled with "a"). 
By default \code{cofactor_df = NULL}, in which case no co-factors are included in the analysis.}

\item{allelic_interaction}{The QTL detection model can be for additive main effects only (by default \code{allelic_interaction = FALSE}). If \code{TRUE}, then the full model is used
(i.e. all possible genotype combinations are included as predictors in the model). This runs the risk of overfitting, especially if double reduction was also allowed. 
Both types of analyses can ideally be performed and compared. Note that if IBD probabilities were estimated using the "heuristic" method rather than the HMM method 
(see \code{\link{estimate_IBD}}), then IBDs are actually haplotype probabilities rather than genotype probabilities, meaning that allelic interaction effects cannot be included in the model.}

\item{folder}{If markers are to be used as co-factors, the path to the folder in which the imported IBD probabilities is contained can be provided here. 
By default this is \code{NULL}, if files are in working directory.}

\item{filename.short}{If TetraOrigin was used and co-factors are being included, the shortened stem of the filename of the \code{.csv} files containing the output of TetraOrigin, 
i.e. without the tail "_LinkageGroupX_Summary.csv" which is added by default to all output of TetraOrigin.}

\item{prop_Pheno_rep}{The minimum proportion of phenotypes represented across blocks. If less than this, the individual is removed from the analysis. If there is incomplete
data, the missing phenotypes are imputed using the mean values across the recorded observations.}

\item{perm_test}{Logical, by default \code{FALSE}. If \code{TRUE}, a permutation test will be performed to determine a
genome-wide significance threshold.}

\item{N_perm.max}{The maximum number of permutations to run if \code{perm_test} is \code{TRUE}; by default this is 1000.}

\item{alpha}{The P-value to be used in the selection of a threshold if \code{perm_test} is \code{TRUE}, by default 0.05 (i.e. the 0.95 quantile).}

\item{gamma}{The width of the confidence intervals used around the permutation test threshold using the approach of Nettleton & Doerge (2000), by default 0.05.}

\item{ncores}{Number of cores to use if parallel computing is required. Works both for Windows and UNIX (using \code{doParallel}).
Use \code{parallel::detectCores()} to find out how many cores you have available.}

\item{log}{Character string specifying the log filename to which standard output should be written. If \code{NULL} log is send to stdout.}

\item{verbose}{Logical, by default \code{TRUE}. Should messages be printed during running?}

\item{\dots}{Arguments passed to \code{\link{plot}}}
}
\value{
A nested list; each list element (per linkage group) contains the following items:
\describe{
\item{QTL.res}{Single matrix of QTL results with columns chromosome, position, LOD, adj.r.squared and PVE (percentage variance explained).}
\item{Perm.res}{If \code{perm_test} = \code{FALSE}, this will be \code{NULL}.
Otherwise, Perm.res contains a list of the results of the permutation test, with list items
"quantile","threshold" and "scores". Quantile refers to which quantile of scores was used to determine the threshold.
Note that scores are each of the maximal LOD scores across the entire genome scan per permutation, thus returning a
genome-wide threshold rather than a chromosome-specific threshold. If the latter is preferred, restricting the
\code{IBD_list} to a single chromosome and re-running the permutation test will provide the desired threshold.}
\item{Residuals}{If a blocking factor or co-factors are used, this is the (named) vector of residuals used as input for the
QTL scan. Otherwise, this is the set of (raw) phenotypes used in the QTL scan.}
\item{Map}{Original map of genetic marker positions upon which the IBDs were based, most often used
for adding rug of marker positions to QTL plots.}
\item{LG_names}{Names of the linkage groups}
\item{allelic_interaction}{Whether argument \code{allelic_interaction} was \code{TRUE} or \code{FALSE} in the QTL scan}
}
}
\description{
Function to run QTL analysis using IBD probabilties given (possibly replicated) phenotypes, assuming randomised experimental design
}
\examples{
data("IBD_4x","Phenotypes_4x")
qtl_LODs.4x <- QTLscan(IBD_list = IBD_4x,
                       Phenotype.df = Phenotypes_4x,
                       genotype.ID = "geno",
                       trait.ID = "pheno",
                       block = "year")
}
