% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{screen_for_duplicate_individuals.gp}
\alias{screen_for_duplicate_individuals.gp}
\title{Screen for duplicate individuals using weighted genotype probabilities}
\usage{
screen_for_duplicate_individuals.gp(
  probgeno_df,
  ploidy,
  parent1 = "P1",
  parent2 = "P2",
  F1,
  cutoff = 0.95,
  plot_cor = TRUE,
  saveCOV = "PeasonCC",
  log = NULL
)
}
\arguments{
\item{probgeno_df}{A data frame as read from the scores file produced by function
\code{saveMarkerModels} of R package \code{fitPoly}, or alternatively, a data frame containing the following columns:
\itemize{
\item{SampleName}{
Name of the sample (individual)
}
\item{MarkerName}{
Name of the marker
}
\item{P0}{
Probabilities of dosage score '0'
}
\item{P1...}{
Probabilities of dosage score '1' etc. (up to max offspring dosage, e.g. P4 for tetraploid population)
}
\item{maxP}{
Maximum genotype probability identified for a particular individual and marker combination
}
\item{maxgeno}{
Most probable dosage for a particular individual and marker combination
}
\item{geno}{
Most probable dosage for a particular individual and marker combination, if \code{maxP} exceeds a user-defined threshold (e.g. 0.9), otherwise \code{NA}
}
}}

\item{ploidy}{The ploidy of parent 1}

\item{parent1}{character vector with the sample names of parent 1}

\item{parent2}{character vector with the sample names of parent 2}

\item{F1}{character vector with the sample names of the F1 individuals}

\item{cutoff}{Correlation coefficient cut off to declare duplicates. At this correlation coefficient, individuals are merged. If \code{NULL} user input will be asked after plotting.}

\item{plot_cor}{Logical. Should correlation coefficients be plotted? Can be memory/CPU intensive with high number of individuals.}

\item{saveCOV}{A file name where the Pearson's correlation coefficient's variation, number, and mean can be saved}

\item{log}{Character string specifying the log filename to which standard output should be written. If \code{NULL} log is send to stdout.}
}
\value{
A data frame similar to input \code{probgeno_df}, but with duplicate individuals merged.
}
\description{
\code{screen_for_duplicate_individuals.gp} identifies and merges duplicate individuals based on probabilistic genotypes.
See \code{\link{screen_for_duplicate_individuals}} for the original function.
}
