% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triang_sylvester.R
\name{triang_Sylvester}
\alias{triang_Sylvester}
\title{Triangularization of a polynomial matrix by Sylvester method}
\usage{
triang_Sylvester(pm, u, eps = ZERO_EPS)
}
\arguments{
\item{pm}{an polynomial matrix to triangularize}

\item{u}{the minimal degree of the triangularizator multiplicator}

\item{eps}{threshold of non zero coefficients}
}
\value{
T - the left-lower triangularized version of the given polynomial matrix
U - the right multiplicator to triangularize the given polynomial matrix
}
\description{
The function \code{triang_Sylvester} triangularize the given polynomial matrix.
}
\details{
The \code{u} parameter is a necessary supplementary input without default value.
This parameter give the minimal degree of the searched triangulizator to solve the problem.

In a polynomial matrix the head elements are the first non-zero polynomials of columns.
The sequence of row indices of this head elements form the \emph{shape} of the polynomial matrix.
A polynomial matrix is in left-lower triangular form, if this sequence is monoton increasing.

This method search a solution of the triangulrization by the method of Sylvester matrix,
descripted in the article Labhalla-Lombardi-Marlin (1996).
}
\references{
Salah Labhalla, Henri Lombardi, Roger Marlin:
Algorithm de calcule de la reduction de Hermite d'une matrice a coefficients polynomiaux,
Theoretical Computer Science 161 (1996) pp 69-92
}
