% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policytree-package.R
\docType{package}
\name{policytree-package}
\alias{policytree}
\alias{policytree-package}
\title{policytree: Policy Learning via Doubly Robust Empirical Welfare Maximization over Trees}
\description{
A package for learning optimal policies via doubly robust empirical welfare maximization over trees. This package implements the multi-action doubly robust approach of Zhou et al. (2018) in the case where we want to learn policies that belong to the class of depth \emph{k} decision trees. Many practical policy applications require interpretable predictions. For example, a drug prescription guide that follows a simple 2-question Yes/No checklist can be encoded as a depth 2 decision tree (does the patient have a heart condition - etc.). \code{policytree} currently has support for estimating multi-action treatment effects with one vs. all \href{https://github.com/grf-labs/grf}{grf}, calculating statistics such as double robust scores (support for a subset of \emph{grf} forest types) and fitting optimal policies with exact tree search.

Some helpful links for getting started:
\itemize{
\item The \href{https://grf-labs.github.io/policytree/}{R package documentation} contains usage examples and method references.
\item For community questions and answers around usage, see the GitHub \href{https://github.com/grf-labs/policytree/issues}{issues page}.
}
}
\examples{
\donttest{
# Multi-action treatment effect estimation
n <- 250
p <- 10
X <- matrix(rnorm(n * p), n, p)
W <- sample(c("A", "B", "C"), n, replace = TRUE)
Y <- X[, 1] + X[, 2] * (W == "B") + X[, 3] * (W == "C") + runif(n)
multi.forest <- multi_causal_forest(X = X, Y = Y, W = W)

# tau.hats
predict(multi.forest)$predictions

# Policy learning
Gamma.matrix <- double_robust_scores(multi.forest)

train <- sample(1:n, 200)
opt.tree <- policy_tree(X[train, ], Gamma.matrix[train, ], depth = 2)
opt.tree

# Predict treatment on held out data
predict(opt.tree, X[-train, ])
}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/grf-labs/policytree}
}

}
\author{
\strong{Maintainer}: Erik Sverdrup \email{erikcs@stanford.edu}

Authors:
\itemize{
  \item Zhengyuan Zhou
  \item Susan Athey
  \item Stefan Wager
  \item Ayush Kanodia
}

}
\keyword{internal}
