% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__expr.R
\name{Expr_ewm_mean_std_var}
\alias{Expr_ewm_mean_std_var}
\alias{Expr_ewm_mean}
\alias{ewm_mean}
\alias{Expr_ewm_std}
\alias{ewm_std}
\alias{Expr_ewm_var}
\alias{ewm_var}
\title{Exponentially-weighted moving average/std/var.}
\usage{
Expr_ewm_mean(
  com = NULL,
  span = NULL,
  half_life = NULL,
  alpha = NULL,
  adjust = TRUE,
  min_periods = 1L,
  ignore_nulls = TRUE
)

Expr_ewm_std(
  com = NULL,
  span = NULL,
  half_life = NULL,
  alpha = NULL,
  adjust = TRUE,
  bias = FALSE,
  min_periods = 1L,
  ignore_nulls = TRUE
)

Expr_ewm_var(
  com = NULL,
  span = NULL,
  half_life = NULL,
  alpha = NULL,
  adjust = TRUE,
  bias = FALSE,
  min_periods = 1L,
  ignore_nulls = TRUE
)
}
\arguments{
\item{com}{Specify decay in terms of center of mass, \eqn{\gamma}, with
\eqn{
  \alpha = \frac{1}{1 + \gamma} \; \forall \; \gamma \geq 0
  }}

\item{span}{Specify decay in terms of span,  \eqn{\theta}, with
\eqn{\alpha = \frac{2}{\theta + 1} \; \forall \; \theta \geq 1 }}

\item{half_life}{Specify decay in terms of half-life, :math:\verb{\\lambda}, with
\eqn{ \alpha = 1 - \exp \left\{ \frac{ -\ln(2) }{ \lambda } \right\} }
\eqn{ \forall \; \lambda > 0}}

\item{alpha}{Specify smoothing factor alpha directly, \eqn{0 < \alpha \leq 1}.}

\item{adjust}{Divide by decaying adjustment factor in beginning periods to account for
imbalance in relative weightings
\itemize{
\item When \code{adjust=TRUE} the EW function is calculated
using weights \eqn{w_i = (1 - \alpha)^i  }
\item When \code{adjust=FALSE} the EW function is calculated
recursively by
\eqn{
  y_0 = x_0 \\
  y_t = (1 - \alpha)y_{t - 1} + \alpha x_t
}
}}

\item{min_periods}{Minimum number of observations in window required to have a value
(otherwise result is null).}

\item{ignore_nulls}{ignore_nulls
Ignore missing values when calculating weights.
\itemize{
\item When \code{ignore_nulls=FALSE} (default), weights are based on absolute
positions.
For example, the weights of :math:\code{x_0} and :math:\code{x_2} used in
calculating the final weighted average of
\code{[} \eqn{x_0}, None,  \eqn{x_2}\\\verb{]} are
\eqn{1-\alpha)^2} and  \eqn{1} if \code{adjust=TRUE}, and
\eqn{(1-\alpha)^2} and  \eqn{\alpha} if \code{adjust=FALSE}.
\item When \code{ignore_nulls=TRUE}, weights are based
on relative positions. For example, the weights of
\eqn{x_0} and  \eqn{x_2} used in calculating the final weighted
average of \code{[} \eqn{x_0}, None,  \eqn{x_2}\verb{]} are
\eqn{1-\alpha} and  \eqn{1} if \code{adjust=TRUE},
and  \eqn{1-\alpha} and  \eqn{\alpha} if \code{adjust=FALSE}.
}}

\item{bias}{When bias=FALSE`, apply a correction to make the estimate statistically unbiased.}
}
\value{
Expr
}
\description{
Exponentially-weighted moving average/std/var.

Ewm_std

Ewm_var
}
\examples{
pl$DataFrame(a = 1:3)$select(pl$col("a")$ewm_mean(com = 1))

pl$DataFrame(a = 1:3)$select(pl$col("a")$ewm_std(com = 1))
pl$DataFrame(a = 1:3)$select(pl$col("a")$ewm_std(com = 1))
}
\keyword{Expr}
